<?php 

add_action( 'bizberg_before_homepage_blog', 'fully_green_homepage_process' );
function fully_green_homepage_process(){ 

	$process_status = bizberg_get_theme_mod( 'fully_green_process_status' );

	if( $process_status == false ){
		return;
	} 

	$subtitle         = bizberg_get_theme_mod( 'fully_green_process_subtitle' );
	$title            = bizberg_get_theme_mod( 'fully_green_process_title' );
	$process_repeater = bizberg_get_theme_mod( 'fully_green_process_repeater' );
	$process_repeater = json_decode( $process_repeater , true );
	$process_repeater = wp_list_pluck( $process_repeater , 'process' ); ?>

	<div class="green_process">

		<div class="container">
			
			<div class="column_wrapper">

				<div class="column left">
					<div class="image"></div>
				</div>
				
				<div class="column right">
					<h3>
						<?php echo esc_html( $subtitle ); ?>
					</h3>
					<h2><?php echo esc_html( $title ); ?></h2>

					<?php 
					if( !empty( $process_repeater ) ){ ?>

						<div class="item_wrapper">

							<?php 
							foreach( $process_repeater as $post_id ){

								if( !empty( $post_id ) ){

									$process_post = get_post( $post_id ); ?>

									<div class="item">
										<span class="icon_wrap">
											<i class="fas fa-check"></i>
										</span>
										<p><?php echo esc_html( sanitize_text_field( $process_post->post_content ) ); ?></p>
									</div>							

									<?php 

								}

							} ?>

						</div>

						<?php
					} ?>

				</div>

			</div>

		</div>

	</div>

	<?php
}