<?php

require get_stylesheet_directory() . '/sections/process.php';
require get_stylesheet_directory() . '/sections/services.php';
require get_stylesheet_directory() . '/customizer/options-process.php';
require get_stylesheet_directory() . '/customizer/options-services.php';

add_action( 'wp_enqueue_scripts', 'fully_green_chld_thm_parent_css' );

function fully_green_chld_thm_parent_css() {

    wp_enqueue_style( 
    	'fully_green_chld_css', 
    	trailingslashit( get_template_directory_uri() ) . 'style.css', 
    	array( 
    		'bootstrap',
    		'font-awesome-5',
    		'bizberg-main',
    		'bizberg-component',
    		'bizberg-style2',
    		'bizberg-responsive' 
    	) 
    );

    if ( is_rtl() ) {
        wp_enqueue_style( 
            'fully_green_parent_rtl',
            trailingslashit( get_template_directory_uri() ) . 'rtl.css'
        );
    }
    
}

add_filter( 'bizberg_sidebar_settings', 'fully_green_sidebar_settings' );
function fully_green_sidebar_settings(){
	return '4';
}

/**
* Change the theme color
*/
add_filter( 'bizberg_theme_color', 'fully_green_change_theme_color' );
add_filter( 'bizberg_header_menu_color_hover_sticky_menu', 'fully_green_change_theme_color' );
add_filter( 'bizberg_header_button_color_sticky_menu', 'fully_green_change_theme_color' );
add_filter( 'bizberg_header_button_color_hover_sticky_menu', 'fully_green_change_theme_color' );
add_filter( 'bizberg_header_menu_color_hover', 'fully_green_change_theme_color' );
add_filter( 'bizberg_header_button_color', 'fully_green_change_theme_color' );
add_filter( 'bizberg_header_button_color_hover', 'fully_green_change_theme_color' );
add_filter( 'bizberg_slider_title_box_highlight_color', 'fully_green_change_theme_color' );
add_filter( 'bizberg_slider_arrow_background_color', 'fully_green_change_theme_color' );
add_filter( 'bizberg_slider_dot_active_color', 'fully_green_change_theme_color' );
add_filter( 'bizberg_read_more_background_color', 'fully_green_change_theme_color' );
add_filter( 'bizberg_read_more_background_color_2', 'fully_green_change_theme_color' );
add_filter( 'bizberg_link_color', 'fully_green_change_theme_color' );
add_filter( 'bizberg_link_color_hover', 'fully_green_change_theme_color' );
add_filter( 'bizberg_blog_listing_pagination_active_hover_color', 'fully_green_change_theme_color' );
add_filter( 'bizberg_sidebar_widget_link_color_hover', 'fully_green_change_theme_color' );
add_filter( 'bizberg_sidebar_widget_title_color', 'fully_green_change_theme_color' );
add_filter( 'bizberg_footer_social_icon_background', 'fully_green_change_theme_color' );
function fully_green_change_theme_color(){
    return '#6ab43e';
}

add_filter( 'bizberg_header_button_border_color', 'fully_green_btn_border_color' );
add_filter( 'bizberg_header_button_border_color_sticky_menu', 'fully_green_btn_border_color' );
function fully_green_btn_border_color(){
    return '#478a41';
}

add_filter( 'bizberg_slider_gradient_primary_color', 'fully_green_slider_gradient_primary_color' );
function fully_green_slider_gradient_primary_color(){
    return 'rgba(106,180,62,0.65)';
}

add_filter( 'bizberg_footer_social_icon_color', 'fully_green_footer_social_icon_color' );
function fully_green_footer_social_icon_color(){
    return '#fff';
}

add_filter( 'bizberg_banner_title', 'fully_green_banner_title' );
function fully_green_banner_title(){
    return esc_html__( 'Time to change by planting trees' , 'fully-green' );
}

add_action( 'after_setup_theme', 'fully_green_setup_theme' );
function fully_green_setup_theme() {
    add_theme_support( 'title-tag' );
    add_theme_support( 'automatic-feed-links' );
}

add_filter( 'bizberg_banner_image', 'fully_green_banner_image' );
function fully_green_banner_image(){
    return [
        'background-color'      => 'rgba(20,20,20,.8)',
        'background-image'      => get_stylesheet_directory_uri() . '/assets/images/landscape-tree-nature-forest-outdoor-wilderness-839604-pxhere.com.jpg',
        'background-repeat'     => 'repeat',
        'background-position'   => 'center center',
        'background-size'       => 'cover',
        'background-attachment' => 'scroll',
    ];
}

add_filter( 'bizberg_footer_social_links' , 'fully_green_footer_social_links' );
function fully_green_footer_social_links(){
    return [];
}

add_filter( 'bizberg_theme_output_css', 'fully_green_theme_output_css' );
function fully_green_theme_output_css( $css ){
    $css[] = array(
        'element'       => '.give-form input[type="submit"], .give-donor__load_more, .nacep-ee-list .event-content input[type="submit"], .nacep-form .em-tickets-form button[type=button], .nacep-form button[type="submit"], .nacep-form input[type="submit"],.nacep-form button[type="submit"]:hover, .nacep-form button[type="submit"]:focus, .give-form input[type="submit"]:hover, .give-form input[type="submit"]:focus, .give-donor__load_more:hover, .give-donor__load_more:focus, .nacep-ee-list .event-content input[type="submit"]:hover, .nacep-ee-list .event-content input[type="submit"]:focus, .nacep-form .em-tickets-form button[type=button]:hover, .nacep-form .em-tickets-form button[type=button]:focus, .nacep-form input[type="submit"]:hover, .nacep-form input[type="submit"]:focus',
        'property'      => 'background',
        'value_pattern' => '$'
    );
    return $css;
}

add_filter( 'bizberg_recommended_plugins', 'fully_green_recommended_plugins' );
function fully_green_recommended_plugins( $plugins ){

    array_push( $plugins , array(
        'name'     => esc_html__( 'Charity Addon for Elementor', 'fully-green' ),
        'slug'     => 'charity-addon-for-elementor',
        'required' => false,
    ));

    array_push( $plugins , array(
        'name'     => esc_html__( 'GiveWP – Donation Plugin and Fundraising Platform', 'fully-green' ),
        'slug'     => 'give',
        'required' => false,
    ));

    return $plugins;

}

add_filter( 'bizberg_getting_started_screenshot', 'fully_green_getting_started_screenshot' );
function fully_green_getting_started_screenshot(){
    return true;
}