<?php

add_action( 'init' , 'fully_green_services' );
function fully_green_services(){

	Kirki::add_section( 'fully_green_services_section', array(
        'title'   => esc_html__( 'Services', 'fully-green' ),
        'section' => 'homepage'
    ) );

    Kirki::add_field( 'bizberg', [
        'type'        => 'checkbox',
        'settings'    => 'fully_green_services_status',
        'label'       => esc_html__( 'Enable / Disable', 'fully-green' ),
        'section'     => 'fully_green_services_section',
        'default'     => false,
    ] );

    Kirki::add_field( 'bizberg', array(
        'type'        => 'advanced-repeater',
        'label'       => esc_html__( 'Services', 'fully-green' ),
        'section'     => 'fully_green_services_section',
        'settings'    => 'fully_green_services_repeater',
        'choices' => [
            'limit' => 6,
            'button_label' => esc_html__( 'Add Services', 'fully-green' ),
            'row_label' => [
                'value' => esc_html__( 'Services', 'fully-green' ),
            ],
            'fields' => [
            	'icon'  => [
	                'type'        => 'fontawesome',
	                'label'       => esc_html__( 'Icon', 'fully-green' ),
	                'default'     => 'fab fa-accusoft',
	                'choices'     => bizberg_get_fontawesome_options(),
	            ],
                'serices_id'  => [
                    'type'        => 'select',
                    'label'       => esc_html__( 'Select Page', 'fully-green' ),
                    'choices'     => bizberg_get_all_pages(),
                ],
            ],
        ],
        'active_callback' => [
            [
                'setting'  => 'fully_green_services_status',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ) );

}