<?php

add_action( 'init' , 'fully_green_process' );
function fully_green_process(){

	Kirki::add_section( 'fully_green_process_section', array(
        'title'   => esc_html__( 'Process', 'fully-green' ),
        'section' => 'homepage'
    ) );

    Kirki::add_field( 'bizberg', [
        'type'        => 'checkbox',
        'settings'    => 'fully_green_process_status',
        'label'       => esc_html__( 'Enable / Disable', 'fully-green' ),
        'section'     => 'fully_green_process_section',
        'default'     => false,
    ] );

    Kirki::add_field( 'bizberg', [
        'type'        => 'image',
        'settings'    => 'fully_green_process',
        'label'       => esc_html__( 'Image', 'fully-green' ),
        'section'     => 'fully_green_process_section',
        'default'     => get_stylesheet_directory_uri() . '/assets/images/landscape-tree-nature-forest-outdoor-wilderness-839604-pxhere.com.jpg',
        'transport'   => 'auto',
        'output' => array(
            array(
                'element'  => '.green_process .column_wrapper .column.left .image',
                'property' => 'background-image',
            ),
        ),
        'active_callback' => [
            [
                'setting'  => 'fully_green_process_status',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ] );

    Kirki::add_field( 'bizberg', [
        'type'     => 'text',
        'settings' => 'fully_green_process_subtitle',
        'label'    => esc_html__( 'Subtitle', 'fully-green' ),
        'section'  => 'fully_green_process_section',
        'default'  => esc_html__( 'Watch Us', 'fully-green' ),
        'active_callback' => [
            [
                'setting'  => 'fully_green_process_status',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ] );

    Kirki::add_field( 'bizberg', [
        'type'     => 'text',
        'settings' => 'fully_green_process_title',
        'label'    => esc_html__( 'Title', 'fully-green' ),
        'section'  => 'fully_green_process_section',
        'default'  => esc_html__( 'How We Care & Grow Our Organic Vegetables', 'fully-green' ),
        'active_callback' => [
            [
                'setting'  => 'fully_green_process_status',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ] );

    Kirki::add_field( 'bizberg', array(
        'type'        => 'advanced-repeater',
        'label'       => esc_html__( 'Process', 'fully-green' ),
        'section'     => 'fully_green_process_section',
        'settings'    => 'fully_green_process_repeater',
        'choices' => [
            'limit' => 3,
            'button_label' => esc_html__( 'Add Process', 'fully-green' ),
            'row_label' => [
                'value' => esc_html__( 'Process', 'fully-green' ),
            ],
            'fields' => [
                'process'  => [
                    'type'        => 'select',
                    'label'       => esc_html__( 'Select Page', 'fully-green' ),
                    'choices'     => bizberg_get_all_pages(),
                ],
            ],
        ],
        'active_callback' => [
            [
                'setting'  => 'fully_green_process_status',
                'operator' => '==',
                'value'    => true,
            ]
        ],
    ) );

}