<?php
/**
 * Block Styles
 *
 * @package fse_lawyer_firm
 * @since 1.0
 */

if ( function_exists( 'register_block_style' ) ) {
	function fse_lawyer_firm_register_block_styles() {

		//Wp Block Padding Zero
		register_block_style(
			'core/group',
			array(
				'name'  => 'fse-lawyer-firm-padding-0',
				'label' => esc_html__( 'No Padding', 'fse-lawyer-firm' ),
			)
		);

		//Wp Block Post Author Style
		register_block_style(
			'core/post-author',
			array(
				'name'  => 'fse-lawyer-firm-post-author-card',
				'label' => esc_html__( 'Theme Style', 'fse-lawyer-firm' ),
			)
		);

		//Wp Block Button Style
		register_block_style(
			'core/button',
			array(
				'name'         => 'fse-lawyer-firm-button',
				'label'        => esc_html__( 'Plain', 'fse-lawyer-firm' ),
			)
		);

		//Post Comments Style
		register_block_style(
			'core/post-comments',
			array(
				'name'         => 'fse-lawyer-firm-post-comments',
				'label'        => esc_html__( 'Theme Style', 'fse-lawyer-firm' ),
			)
		);

		//Latest Comments Style
		register_block_style(
			'core/latest-comments',
			array(
				'name'         => 'fse-lawyer-firm-latest-comments',
				'label'        => esc_html__( 'Theme Style', 'fse-lawyer-firm' ),
			)
		);


		//Wp Block Table Style
		register_block_style(
			'core/table',
			array(
				'name'         => 'fse-lawyer-firm-wp-table',
				'label'        => esc_html__( 'Theme Style', 'fse-lawyer-firm' ),
			)
		);


		//Wp Block Pre Style
		register_block_style(
			'core/preformatted',
			array(
				'name'         => 'fse-lawyer-firm-wp-preformatted',
				'label'        => esc_html__( 'Theme Style', 'fse-lawyer-firm' ),
			)
		);

		//Wp Block Verse Style
		register_block_style(
			'core/verse',
			array(
				'name'         => 'fse-lawyer-firm-wp-verse',
				'label'        => esc_html__( 'Theme Style', 'fse-lawyer-firm' ),
			)
		);
	}
	add_action( 'init', 'fse_lawyer_firm_register_block_styles' );
}
