<?php
/**
 * Block Patterns
 *
 * @package fse_lawyer_firm
 * @since 1.0
 */

function fse_lawyer_firm_register_block_patterns() {
	$fse_lawyer_firm_block_pattern_categories = array(
		'fse-lawyer-firm' => array( 'label' => esc_html__( 'FSE Lawyer Firm', 'fse-lawyer-firm' ) ),
		'pages' => array( 'label' => esc_html__( 'Pages', 'fse-lawyer-firm' ) ),
	);

	$fse_lawyer_firm_block_pattern_categories = apply_filters( 'fse_lawyer_firm_fse_lawyer_firm_block_pattern_categories', $fse_lawyer_firm_block_pattern_categories );

	foreach ( $fse_lawyer_firm_block_pattern_categories as $name => $properties ) {
		if ( ! WP_Block_Pattern_Categories_Registry::get_instance()->is_registered( $name ) ) {
			register_block_pattern_category( $name, $properties );
		}
	}
}
add_action( 'init', 'fse_lawyer_firm_register_block_patterns', 9 );