<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package friyan
 */

?>
<div class="col-md-12">
    <div id="post-<?php the_ID(); ?>" <?php post_class();?>>
        <div class="blog-entry d-md-flex">
            <?php friyan_post_thumbnail(); ?>
            <div class="text text-2 pl-md-4">
                <h3 class="mb-2">
                    <?php
				if ( is_singular() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif;
				?>
                </h3>
                <div class="meta-wrap">
                    <p class="meta">
                        <span><i class="friyan-icon-calendar mr-2"></i><?php friyan_posted_on();?></span>
                        <span><?php friyan_get_category(); ?></span>
                        <span>
                            <i
                                class="friyan-icon-comment mr-2"></i><?php echo get_comments_number($post->ID); _e(' Comment', 'friyan');?></span>
                    </p>
                </div>
                <p class="mb-3">
                    <?php
				the_content(
					sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'friyan' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						wp_kses_post( get_the_title() )
					)
				);?>
                </p>
            </div>
        </div>
    </div>
</div>
<!-- #post-<?php the_ID(); ?> -->