<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package friyan
 */

?>
<div class="col-md-12">
	<div id="post-<?php the_ID(); ?>" <?php post_class('blog-entry-2');?>>
		<?php the_post_thumbnail('friyan-blog-thumbnail'); ?>
		<div class="text pt-3">
			<h3 class="mb-2">
			  <?php
				if ( is_singular() ) :
					the_title( '<h1 class="entry-title">', '</h1>' );
				else :
					the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
				endif;
				?>
			</h3>
			<div class="meta-wrap">
				<p class="meta">
					<span class="post-meta"><i class="friyan-icon-calendar mr-2"></i><?php friyan_posted_on();?></span>
					<span class="cat-meta"><?php friyan_get_category(); ?></span>
					<span class="comment-meta">
						<i
							class="friyan-icon-comment mr-2"></i><?php echo get_comments_number($post->ID); _e(' Comment', 'friyan');?></span>
				</p>
			</div>
		 <?php
			the_content(
				sprintf(
					wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
						__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'friyan' ),
						array(
							'span' => array(
								'class' => array(),
							),
						)
					),
					wp_kses_post( get_the_title() )
				)
			);?>
		</div>
	</div>
</div>
<!-- #post-<?php the_ID(); ?> -->
