<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package friyan
 */

?>
<div class="col-md-12">
    <div id="post-<?php the_ID(); ?>" <?php post_class();?>>
        <div class="blog-entry d-md-flex">
            <div class="thumbnail-wrap">
				<?php
				if(has_post_thumbnail()){
				?>
				<div class="gu">
					<svg width="165" height="165" class="circle-svg" viewBox="0 0 144 144"><path fill-rule="evenodd" clip-rule="evenodd" d="M72 1.7c-27.28 0-50.93 16.1-62.47 39.61L8 40.56C19.8 16.51 44.02 0 72 0c27.98 0 52.2 16.5 64 40.56l-1.53.75C122.93 17.8 99.27 1.71 72 1.71zM9.53 102.7c11.54 23.51 35.2 39.6 62.47 39.6 27.28 0 50.93-16.09 62.47-39.6l1.53.75C124.2 127.49 99.98 144 72 144c-27.98 0-52.2-16.5-64-40.56l1.53-.75z"></path></svg>
					<?php the_post_thumbnail('thumbnail',array('class' => 'img-fluid rounded-circle')); ?>
				</div>
				<?php }?>
            </div>
            <div class="text text-2 pl-md-3">
                <?php
				if ( is_singular() ) :
					the_title( '<h3 class="entry-title">', '</h3>' );
				else :
					the_title( '<h3 class="mb-2 entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
				endif;
				?>
                <div class="meta-wrap">
                    <p class="meta">
                        <span><i class="friyan-icon-calendar mr-2"></i><?php friyan_posted_on();?></span>
                        <span><?php friyan_get_category(); ?></span>
                        <span>
                            <i
                                class="friyan-icon-comment mr-2"></i><?php echo get_comments_number($post->ID); _e(' Comment', 'friyan');?></span>
                    </p>
                </div>
                <p class="mb-3">
                    <?php echo friyan_get_excerpt(120);?>
                </p>
            </div>
        </div>
    </div>
</div>
<!-- #post-<?php the_ID(); ?> -->