<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package friyan
 */

get_header();
?>

<div id="friyan-main">
    <section class="fri-section fri-no-pt fri-no-pb">
        <div class="container-fluid">
            <div class="row d-flex">
			<?php friyan_left_sidebar();?>
                <div class="col-fmd-55 col-sm-12 py-5 px-md-5">

                    <div id="friyan-skip" class="row">
                        <?php
					if ( have_posts() ) :

						if ( is_home() && ! is_front_page() ) :
							?>
                        <header>
                            <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
                        </header>
                        <?php
						endif;

						/* Start the Loop */
						while ( have_posts() ) :
							the_post();

							/*
							 * Include the Post-Type-specific template for the content.
							 * If you want to override this in a child theme, then include a file
							 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
							 */
							get_template_part( 'template-parts/content', 'single');
							the_post_navigation(
								array(
									'prev_text' => '<span class="nav-subtitle">' . esc_html__( 'Previous:', 'friyan' ) . '</span> <span class="nav-title">%title</span>',
									'next_text' => '<span class="nav-subtitle">' . esc_html__( 'Next:', 'friyan' ) . '</span> <span class="nav-title">%title</span>',
								)
							);

							// If comments are open or we have at least one comment, load up the comment template.
							if ( comments_open() || get_comments_number() ) :
								comments_template();
							endif;
						endwhile;
						endif;
					
					?>
                    </div>
                    <!-- END COL -->
                </div>
                <?php get_sidebar();?>
            </div>
        </div>
    </section>
</div>

<?php
get_footer();