<?php
/**
 * Template for displaying search forms in Oncue
 *
 * @package WordPress
 * @subpackage Oncue
 * @since 1.0
 * @version 1.0
 */
?>
<div class="widget widget-search">
    <form action="<?php echo esc_url( home_url( '/' ) ); ?>" method="get" class="search-form input-group">
        <div class="form-group">
            <span class="icon friyan-icon-search"></span>
            <input type="text" name="s" id="search" class="form-control input-lg" value="<?php the_search_query(); ?>"
                placeholder="<?php echo esc_attr_x( 'Type keyword and press enter', 'placeholder', 'friyan' ); ?>">
        </div>
    </form>
</div>
