<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package friyan
 */

get_header();
?>

<div id="friyan-main">
    <section class="fri-section fri-no-pt fri-no-pb">
        <div class="container-fluid">
            <div id="friyan-skip" class="row d-flex">
			<?php friyan_left_sidebar();?>
                <div class="col-fmd-55 py-5 px-md-5">
                    <h2 class="search-title text-center">
                        <?php
						/* translators: %s: search query. */
						printf( esc_html__( 'Search Results for : %s', 'friyan' ), '<span>' . get_search_query() . '</span>' );
					?>
                    </h2>
                    <hr>
                    <div class="pt-md-4">
                        <?php
					
						if ( have_posts() ) :
							if ( is_home() && ! is_front_page() ) :
						?>
                        <div class="search-heading">

                        </div>
                        <header>
                            <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
                        </header>
                        <?php
						endif;

						/* Start the Loop */
						while ( have_posts() ) :
							the_post();

							/*
							 * Include the Post-Type-specific template for the content.
							 * If you want to override this in a child theme, then include a file
							 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
							 */
							get_template_part( 'template-parts/content', 'search');

						endwhile;

						if(function_exists('friyan_the_posts_pagination')):
							friyan_the_posts_pagination();
						endif;

					else :

						get_template_part( 'template-parts/content', 'none' );

					endif;
					?>
                    </div>

                    <!-- END COL -->
                </div>
                <?php get_sidebar();?>
            </div>
        </div>
    </section>
</div>

<?php
get_footer();