<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package friyan
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function friyan_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'friyan_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function friyan_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'friyan_pingback_header' );

/*
Custom Excerpt 
*/
function friyan_get_excerpt( $count ) {
	global $post;
	$permalink = esc_url(get_permalink($post->ID));
	$excerpt = get_the_content();
	$excerpt = strip_tags($excerpt);
	$excerpt = substr($excerpt, 0, $count);
	$excerpt = wp_kses_post(substr($excerpt, 0, strripos($excerpt, " ")));
	if(!is_home() || !is_front_page()){
	$excerpt = '<p>'.$excerpt.'...<br> <a href="'.$permalink.'" class="btn-more d-block mt-3">'. __('Read More','friyan') .' &#10230;</a></p>';
	return $excerpt;
	}else{
	$excerpt = '<p>'.$excerpt.'...<br> <a href="'.$permalink.'" class="btn-more d-block mt-3">'. __('Read More','friyan') .' &#10230;</a></p>';
	return $excerpt;
	}
}
/*
Add Image Size 
*/
function friyan_thumbsize() {
	add_image_size( 'friyan-sidebar-thumbnail', 100, 80, true );
	add_image_size( 'friyan-search-thumbnail', 150, 150, true );
	add_image_size( 'friyan-home-thumbnail', 105, 106, true );
	add_image_size( 'friyan-blog-thumbnail', 1200, 628, true );
}
add_action( 'after_setup_theme', 'friyan_thumbsize' );

/*
Pagination
*/

function friyan_the_posts_pagination() {
	the_posts_pagination( array(
		'mid_size' => 2,
		'prev_text' => __( '&laquo;', 'friyan' ),
		'next_text' => __( '&raquo;', 'friyan' ),
	) );
}
/*
Left Sidebar 
*/
function friyan_left_sidebar(){?>

<aside  role="complementary" class="left-sidebar col-fmd-20 col-sm-12 p-0">
   
	<nav class="navbar" data-function="navbar">
	<?php
		the_custom_logo();
		if ( is_front_page() && is_home() ) :
		?>
		
		<h1 class="site-title">
			<a class="brand" href="<?php echo esc_url( home_url( '/' ) ); ?>"
				rel="home"><?php bloginfo( 'name' ); ?></a>
		</h1>
		<?php
		else :
			?>
		<h1 class="site-title">
			<a  class="brand" href="<?php echo esc_url( home_url( '/' ) ); ?>"
				rel="home"><?php bloginfo( 'name' ); ?></a>
		</h1>
		<?php
		endif;
		$friyan_description = get_bloginfo( 'description', 'display' );
		if ( $friyan_description || is_customize_preview() ) :
		?>
		<p class="site-description">
			<?php echo $friyan_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
		</p>
		<?php endif; ?>
			
			<button class="navbar-toggle">
				<i class="menu-icon fa fa-bars"></i>
			</button>
		<?php
			wp_nav_menu( array(
				'theme_location'    => 'menu-1',
				'depth'             => 3,
				'menu_class'        => 'nav',
				'items_wrap'		=> '<ul class="nav navbar-nav" data-function="navbar">%3$s</ul>',
				
			) );
		?>
	</nav>
				
<div class="site-info">
<?php 
/**
 * Hook - friyan_copyright_info_hook
 *
 * @hooked friyan_copyright_info - 10
 */
do_action('friyan_copyright_info_hook');
?>
</div><!-- .copyright-info -->
</aside>
<?php 
}
/*
copyright info
hook 
*/
add_action('friyan_copyright_info_hook', 'friyan_copyright_info', 10);

function friyan_copyright_info(){?>
	
		<?php
		if ( is_active_sidebar( 'copyright' ) ) {?>
		<small class="m-0">
		<?php dynamic_sidebar( 'copyright' );?>
		</small>
		<?php
		}else{
		?>
		<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'friyan' ) ); ?>">
			<?php
			/* translators: %s: CMS name, i.e. WordPress. */
			printf( esc_html__( 'Proudly powered by %s', 'friyan' ), 'WordPress' );
			?>
		</a>
		<?php }?>
<?php 
}

/* 
Page loader 
*/
function friyan_loader(){?>
<div id="fri-loader" class="show fullscreen">
    <svg class="circular" width="48px" height="48px">
        <circle class="path-bg" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke="#eeeeee" />
        <circle class="path" cx="24" cy="24" r="22" fill="none" stroke-width="4" stroke-miterlimit="10"
            style="stroke:var(--primary)" />
    </svg>
</div>
<?php }
add_action('friyan_loader_hook', 'friyan_loader');

/*
 Comment list
*/
function friyan_comment($comment, $args, $depth) {
?>
<li <?php comment_class('comment'); ?> id="li-comment-<?php comment_ID() ?>">
    <div class="vcard bio">
        <?php echo get_avatar($comment, 60 ); ?>
    </div>
    <div class="comment-body">
        <?php printf(__('<h3 class="fn">%s</h3>','friyan'), get_comment_author_link()) ?>
        <div class="meta">
            <a href="<?php echo htmlspecialchars( get_comment_link( $comment->comment_ID ) ) ?>">
                <?php printf(__('%1$s at %2$s','friyan'), get_comment_date(),  get_comment_time()) ?>
            </a>
            <?php edit_comment_link(__('(Edit)', 'friyan'),'  ','') ?>
        </div>
        <?php if ($comment->comment_approved == '0') : ?>
        <em><?php _e('Your comment is awaiting moderation.','friyan') ?></em>
        <br />
        <?php endif; ?>

        <?php comment_text() ?>

        <div class="reply">
            <?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
        </div>
    </div>
</li>
 <?php
 }
 /*
 Add arrow in dropdown menu
*/
 function friyan_menu_arrow($item_output, $item, $depth, $args) {
    if (in_array('menu-item-has-children', $item->classes)) {
        $arrow = '<svg class="parent-toggle" viewBox="0 0 1024 1024">
							<path d="M316 334l196 196 196-196 60 60-256 256-256-256z" />
						</svg>';
        $item_output = str_replace('</a>', ''. $arrow .'</a>', $item_output);
    }
    return $item_output;
}
add_filter('walker_nav_menu_start_el', 'friyan_menu_arrow', 10, 4);
?>