<?php
/**
 * friyan Theme Customizer
 *
 * @package friyan
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function friyan_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'friyan_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'friyan_customize_partial_blogdescription',
			)
		);
	}
	 /** 
   Sidebar Color
  **/
	$wp_customize->add_setting(
      'friyan_secondary_color', //give it an ID
      array(
		'transport' => 'postMessage',
        'default' => '#f0f7fe', // Give it a default
		'sanitize_callback' => 'sanitize_hex_color',
      )
	);
	$wp_customize->add_control(
     new WP_Customize_Color_Control(
         $wp_customize,
         'friyan_secondary_color', //give it an ID
         array(
             'label'      => __( 'Sidebar background', 'friyan' ), //set the label to appear in the Customizer
             'section'    => 'colors', //select the section for it to appear under  
             'settings'   => 'friyan_secondary_color' //pick the setting it applies to
         )
    )
  );
   /** 
   Sidebar text Color
  **/
	$wp_customize->add_setting(
      'friyan_sidebar_text_color', //give it an ID
      array(
		'transport' => 'postMessage',
        'default' => '#333', // Give it a default
		'sanitize_callback' => 'sanitize_hex_color',
      )
	);
	$wp_customize->add_control(
     new WP_Customize_Color_Control(
         $wp_customize,
         'friyan_sidebar_text_color', //give it an ID
         array(
             'label'      => __( 'Sidebar Text Color', 'friyan' ), //set the label to appear in the Customizer
             'section'    => 'colors', //select the section for it to appear under  
             'settings'   => 'friyan_sidebar_text_color' //pick the setting it applies to
         )
    )
  );
	/** 
   Primary Color
  **/
	$wp_customize->add_setting(
      'friyan_primary_color', //give it an ID
      array(
		'transport' => 'postMessage',
        'default' => '#007bff', // Give it a default
		'sanitize_callback' => 'sanitize_hex_color',
      )
	);
	$wp_customize->add_control(
     new WP_Customize_Color_Control(
         $wp_customize,
         'friyan_primary_color', //give it an ID
         array(
             'label'      => __( 'Primary Color', 'friyan' ), //set the label to appear in the Customizer
             'section'    => 'colors', //select the section for it to appear under  
             'settings'   => 'friyan_primary_color' //pick the setting it applies to
         )
    )
  );
 
  /** 
   Title Color
  **/
	$wp_customize->add_setting(
      'friyan_title_color', //give it an ID
      array(
		'transport' => 'postMessage',
        'default' => '#000000cc', // Give it a default
		'sanitize_callback' => 'sanitize_hex_color',
      )
	);
	$wp_customize->add_control(
     new WP_Customize_Color_Control(
         $wp_customize,
         'friyan_title_color', //give it an ID
         array(
             'label'      => __( 'Title Color', 'friyan' ), //set the label to appear in the Customizer
             'section'    => 'colors', //select the section for it to appear under  
             'settings'   => 'friyan_title_color' //pick the setting it applies to
         )
    )
  );
  
}
add_action( 'customize_register', 'friyan_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function friyan_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function friyan_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function friyan_customize_preview_js() {
	wp_enqueue_script( 'friyan-customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'friyan_customize_preview_js' );


add_action( 'wp_head', 'friyan_customize_css' );
function friyan_customize_css() {
?>
<style type="text/css">
:root{
	--primary: <?php echo esc_attr(get_theme_mod('friyan_primary_color', '#007bff'));?>;
	--secondary: <?php echo esc_attr(get_theme_mod('friyan_secondary_color', '#f0f7fe'));?>;
	--title_color: <?php echo esc_attr(get_theme_mod('friyan_title_color', '#000000cc'));?>;
	--sidebar_text_color: <?php echo esc_attr(get_theme_mod('friyan_sidebar_text_color', '#333'));?>;
}
</style>
<?php
}