<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package friyan
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php
	if ( function_exists( 'wp_body_open' ) ) {
    wp_body_open();
	} else {
	do_action( 'wp_body_open' );
	}
	?>
    <?php do_action('friyan_loader_hook');?>
    <div id="page" class="site">
        <a class="skip-link screen-reader-text"
			href="#friyan-skip"><?php esc_html_e( 'Skip to content', 'friyan' ); ?></a>