<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package friyan
 */

get_header();
?>

<div id="friyan-main">
    <section class="fri-section fri-no-pt fri-no-pb">
        <div class="container-fluid">
            <div class="row d-flex">
			 <?php friyan_left_sidebar();?>
                <div class="col-fmd-55 col-sm-12 py-5 px-md-5">
                    <div id="friyan-skip" class="pt-md-4">
                        <section class="error-404 not-found text-center">
                            <header class="page-header mt-6">
                                <h1><?php esc_html_e( '404 Not Found', 'friyan' ); ?></h1>
                                <h3 class="page-title mt-3">
                                    <?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'friyan' ); ?>
                                </h3>
                            </header><!-- .page-header -->

                            <div class="page-content widget_search">

                                <p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'friyan' ); ?>
                                </p>
								
                                <?php
                                    get_search_form();
                                 ?>
                                <a class="btn btn-primary"
                                    href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e( 'Back to Home', 'friyan' ); ?></a>

                            </div><!-- .page-content -->
                        </section><!-- .error-404 -->
                    </div>

                    <!-- END COL -->
                </div>
                <?php get_sidebar();?>
            </div>
        </div>
    </section>
</div>

<?php
get_footer();