<?php

// Exit if accessed directly.
if (! defined('ABSPATH')) {
  exit;
}

// Theme Object
$fresh_blog_lite_theme = wp_get_theme();
?>

<div class="wrap">
  <h1><?php esc_html_e('Theme Info', 'fresh-blog-lite'); ?></h1>

  <div id="welcome-panel" class="welcome-panel">
    <div class="welcome-panel-content">
      <div class="welcome-panel-header">
        <div class="welcome-panel-header-image">
          <svg preserveAspectRatio="xMidYMin slice" fill="none" viewBox="0 0 1232 240" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <g clip-path="url(#a)">
              <path fill="#0a192f" d="M0 0h1232v240H0z"></path>
              <ellipse cx="616" cy="232" fill="url(#b)" opacity=".05" rx="1497" ry="249"></ellipse>
              <mask id="d" width="1000" height="400" x="232" y="20" maskUnits="userSpaceOnUse" style="mask-type:alpha">
                <path fill="url(#c)" d="M0 0h1000v400H0z" transform="translate(232 20)"></path>
              </mask>
              <g stroke-width="2" mask="url(#d)">
                <path stroke="url(#e)" d="M387 20v1635"></path>
                <path stroke="url(#f)" d="M559.5 20v1635"></path>
                <path stroke="url(#g)" d="M732 20v1635"></path>
                <path stroke="url(#h)" d="M904.5 20v1635"></path>
                <path stroke="url(#i)" d="M1077 20v1635"></path>
              </g>
            </g>
            <defs>
              <linearGradient id="e" x1="387.5" x2="387.5" y1="20" y2="1655" gradientUnits="userSpaceOnUse">
                <stop stop-color="#3858E9" stop-opacity="0"></stop>
                <stop offset=".297" stop-color="#3858E9"></stop>
                <stop offset=".734" stop-color="#3858E9"></stop>
                <stop offset="1" stop-color="#3858E9" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#3858E9" stop-opacity="0"></stop>
              </linearGradient>
              <linearGradient id="f" x1="560" x2="560" y1="20" y2="1655" gradientUnits="userSpaceOnUse">
                <stop stop-color="#FFFCB5" stop-opacity="0"></stop>
                <stop offset="0" stop-color="#FFFCB5" stop-opacity="0"></stop>
                <stop offset=".297" stop-color="#FFFCB5"></stop>
                <stop offset=".734" stop-color="#FFFCB5"></stop>
                <stop offset="1" stop-color="#FFFCB5" stop-opacity="0"></stop>
              </linearGradient>
              <linearGradient id="g" x1="732.5" x2="732.5" y1="20" y2="1655" gradientUnits="userSpaceOnUse">
                <stop stop-color="#C7FFDB" stop-opacity="0"></stop>
                <stop offset=".297" stop-color="#C7FFDB"></stop>
                <stop offset=".693" stop-color="#C7FFDB"></stop>
                <stop offset="1" stop-color="#C7FFDB" stop-opacity="0"></stop>
              </linearGradient>
              <linearGradient id="h" x1="905" x2="905" y1="20" y2="1655" gradientUnits="userSpaceOnUse">
                <stop stop-color="#FFB7A7" stop-opacity="0"></stop>
                <stop offset=".297" stop-color="#FFB7A7"></stop>
                <stop offset=".734" stop-color="#FFB7A7"></stop>
                <stop offset="1" stop-color="#3858E9" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#FFB7A7" stop-opacity="0"></stop>
              </linearGradient>
              <linearGradient id="i" x1="1077.5" x2="1077.5" y1="20" y2="1655" gradientUnits="userSpaceOnUse">
                <stop stop-color="#7B90FF" stop-opacity="0"></stop>
                <stop offset=".297" stop-color="#7B90FF"></stop>
                <stop offset=".734" stop-color="#7B90FF"></stop>
                <stop offset="1" stop-color="#3858E9" stop-opacity="0"></stop>
                <stop offset="1" stop-color="#7B90FF" stop-opacity="0"></stop>
              </linearGradient>
              <radialGradient id="b" cx="0" cy="0" r="1" gradientTransform="matrix(0 249 -1497 0 616 232)" gradientUnits="userSpaceOnUse">
                <stop stop-color="#3858E9"></stop>
                <stop offset="1" stop-color="#0a192f" stop-opacity="0"></stop>
              </radialGradient>
              <radialGradient id="c" cx="0" cy="0" r="1" gradientTransform="matrix(0 765 -1912.5 0 500 -110)" gradientUnits="userSpaceOnUse">
                <stop offset=".161" stop-color="#0a192f" stop-opacity="0"></stop>
                <stop offset=".682"></stop>
              </radialGradient>
              <clipPath id="a">
                <path fill="#fff" d="M0 0h1232v240H0z"></path>
              </clipPath>
            </defs>
          </svg>
        </div>
        <h2><?php echo esc_html($fresh_blog_lite_theme->get('Name')); ?></h2>
        <p>
          <a href="<?php echo esc_url($fresh_blog_lite_theme->get('ThemeURI')); ?>" class="button button-primary" target="_blank" rel="noopener noreferrer nofollow">
            <?php esc_html_e('Upgrade Now', 'fresh-blog-lite'); ?>
          </a>
        </p>
      </div>
      <div class="welcome-panel-column-container">
        <div class="welcome-panel-column">
          <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <rect width="48" height="48" rx="4" fill="#0a192f"></rect>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M32.0668 17.0854L28.8221 13.9454L18.2008 24.671L16.8983 29.0827L21.4257 27.8309L32.0668 17.0854ZM16 32.75H24V31.25H16V32.75Z" fill="white"></path>
          </svg>
          <div class="welcome-panel-column-content">
            <h3><?php esc_html_e('Discount Code: WPLOVE', 'fresh-blog-lite'); ?></h3>
            <p><?php esc_html_e('Upgrade this theme or buy any theme/bundle with discount code. Thank you for your support.', 'fresh-blog-lite'); ?></p>
          </div>
        </div>
        <div class="welcome-panel-column">
          <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <rect width="48" height="48" rx="4" fill="#0a192f"></rect>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M18 16h12a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H18a2 2 0 0 1-2-2V18a2 2 0 0 1 2-2zm12 1.5H18a.5.5 0 0 0-.5.5v3h13v-3a.5.5 0 0 0-.5-.5zm.5 5H22v8h8a.5.5 0 0 0 .5-.5v-7.5zm-10 0h-3V30a.5.5 0 0 0 .5.5h2.5v-8z" fill="#fff"></path>
          </svg>
          <div class="welcome-panel-column-content">
            <h3><?php esc_html_e('Premium Features', 'fresh-blog-lite'); ?></h3>
            <p><?php esc_html_e('Pro gives you exclusive blocks and patterns to elevate your site with a sleek, professional style.', 'fresh-blog-lite'); ?></p>
          </div>
        </div>
        <div class="welcome-panel-column">
          <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <rect width="48" height="48" rx="4" fill="#0a192f"></rect>
            <path fill-rule="evenodd" clip-rule="evenodd" d="M31 24a7 7 0 0 1-7 7V17a7 7 0 0 1 7 7zm-7-8a8 8 0 1 1 0 16 8 8 0 0 1 0-16z" fill="#fff"></path>
          </svg>
          <div class="welcome-panel-column-content">
            <h3><?php esc_html_e('All Access Pass', 'fresh-blog-lite'); ?></h3>
            <p><?php esc_html_e('Unlock all current and future WordPress themes with the All Access Pass — one pass, one low price.', 'fresh-blog-lite'); ?></p>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
