<?php 
/**
 * Template part for displaying Featured Services Section
 *
 * @package freelancer-resume  
 */

$freelancer_resume_featured_services_section_maintaitle = freelancer_resume_get_option('featured_services_section_maintaitle');
$freelancer_resume_featured_services_section_subtitle  = freelancer_resume_get_option('featured_services_section_subtitle');
$freelancer_resume_featured_services_section_subtitle1 = freelancer_resume_get_option('featured_services_section_subtitle1');
$services_excerpt_mainpagelength                       = freelancer_resume_get_option('services_excerpt_mainpagelength');

// Fetch only the 4 selected page IDs from the Customizer using get_theme_mod()
$featured_services_posts = array_filter(array(
	get_theme_mod('featured_services_page_1'),
	get_theme_mod('featured_services_page_2'),
	get_theme_mod('featured_services_page_3'),
	get_theme_mod('featured_services_page_4'),
));

if ( ! get_theme_mod('freelancerresume_enable_featured_services_section', true) ) {
	return;
}
?>

<section id="featured-services">
	<div class="container p-0">
		<div class="row">
			<div class="col-12">
				<div class="entry-content3 text-center">
					<h5><span class="icon"></span><?php echo esc_html( $freelancer_resume_featured_services_section_maintaitle ); ?></h5>
					<h6><?php echo esc_html( $freelancer_resume_featured_services_section_subtitle ); ?></h6>
					<h6><?php echo esc_html( $freelancer_resume_featured_services_section_subtitle1 ); ?></h6>
				</div>
			</div>
		</div>

		<div class="row servicerightsiderow">
			<div class="servicerightside">
				<?php
				if ( ! empty( $featured_services_posts ) ) :
					$args  = array(
						'post_type'      => 'page',
						'post__in'       => $featured_services_posts,
						'posts_per_page' => count( $featured_services_posts ),
						'orderby'        => 'post__in',
					);
					$query = new WP_Query( $args );

					if ( $query->have_posts() ) :
						while ( $query->have_posts() ) : $query->the_post();

							$image_url     = has_post_thumbnail()
								? get_the_post_thumbnail_url( get_the_ID(), 'full' )
								: get_template_directory_uri() . '/assets/images/no-images.jpg';

							$image_height  = absint( get_theme_mod( 'featured_services_post_image_height', 190 ) );
							$onload_effect = esc_attr( get_theme_mod( 'freelancer_resume_featured_services_onload_effects', 'wow zoomIn' ) );
							$text_align    = strtolower( esc_attr( get_theme_mod( 'featured_services_box_align', 'left' ) ) );

							// Fallback for unexpected align values
							$allowed_align = array( 'left', 'right', 'center' );
							if ( ! in_array( $text_align, $allowed_align, true ) ) {
								$text_align = 'left';
							}
							?>			
							<article class="<?php echo $onload_effect; ?>" data-wow-duration="2s">
								<div class="featured-service-item">
									<div class="entry-container" style="text-align: <?php echo $text_align; ?>;">
										<div class="entry-content">
											<div class="border-bottom1">
												<h2 class="entry-title">
													<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
												</h2>
											</div>
										</div>
										<div class="service-image" style="height: <?php echo $image_height; ?>px;">
											<a href="<?php the_permalink(); ?>">
												<img src="<?php echo esc_url( $image_url ); ?>" alt="<?php the_title_attribute(); ?>" style="height: 100%; width: 100%; border-radius: 5px;">
											</a>
										</div>
										<a href="<?php the_permalink(); ?>">
											<div class="service-arrow"></div>
										</a>
									</div>
								</div>
							</article>
						<?php
						endwhile;
						wp_reset_postdata();
					endif;
				endif;
				?>
			</div>
		</div>
	</div>
</section>
