<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package freelancer-resume
 */

?>

<div class="maincontent">
    <div class="post-item">
        <div class="featured-image" style="height: <?php echo absint( get_theme_mod( 'featured_posts_image_height', 55 ) ); ?>px;">
            
            <div class="date-post">
                <h4 class="post-date">
                    <a href="<?php the_permalink(); ?>"><?php echo esc_html(get_the_date('j, F, Y')); ?></a>
                </h4>
            </div>

            <!-- <div class="entry-meta">
                <h4 class="me-1">
                    <i class="fa-solid fa-user pe-2"></i>
                    <a href="</?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>" class="author">
                        </?php echo esc_html(get_the_author()); ?>
                    </a>
                </h4>
                <h4 class="me-1">
                    <i class="fa-solid fa-comments pe-2"></i>
                    <a href="</?php echo esc_url(get_comments_link()); ?>">
                        Comment (</?php echo esc_html(get_comments_number()); ?>)
                    </a>
                </h4>
            </div> -->
        </div>

        <div class="entry-container">
            <header class="pb-1">
                <h2 class="page-title mb-0">
                    <a href="<?php echo esc_url(get_permalink()); ?>">
                        <?php echo esc_html(get_the_title()); ?>
                    </a>
                </h2>
            </header>

            <!-- Optional excerpt -->
            <?php
            // Uncomment to show excerpt
            echo '<p>' . wp_kses_post(wp_trim_words(get_the_content(), 13, '...')) . '</p>';
            ?>

            <p>
                <a class="readbtn" href="<?php echo esc_url(get_permalink()); ?>">
                    <?php echo esc_html__('Read More', 'freelancer-resume'); ?><i class="fa-thin fa-right-long"></i>
                </a>
            </p>
        </div>
    </div>
</div>
