<?php
/**
 * About Section options.
 *
 * @package freelancer-resume
 */

$freelancer_resume_default = freelancer_resume_get_default_theme_options();


$wp_customize->add_section(
    'freelancerresume_featured_services_info_section',
    array(
        'title' => __('Service Info', 'freelancer-resume'),
        'priority' => 2,
        'panel' => 'freelancer_resume_section_panel',
    )
);

// Enable Section
$wp_customize->add_setting('freelancerresume_enable_featured_services_section', 
	array(
	'default' 			=> $freelancer_resume_default['freelancerresume_enable_featured_services_section'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'freelancer_resume_sanitize_switch'
	)
);

$wp_customize->add_control('freelancerresume_enable_featured_services_section', 
	array(		
	'label' 	=> __('Enable Section', 'freelancer-resume'),
	'section' 	=> 'freelancerresume_featured_services_info_section',
	'settings'  => 'freelancerresume_enable_featured_services_section',
	'type' 		=> 'checkbox',	
	)
);


// /// effects
$wp_customize->add_setting('freelancer_resume_featured_services_onload_effects', array(
    'default' => 'zoom-in',
    'sanitize_callback' => 'freelancer_resume_sanitize_choices',
));
$wp_customize->add_control('freelancer_resume_featured_services_onload_effects', array(
    'type' => 'select',
    'label' => __('Box Onload Transition Effects', 'freelancer-resume'),
    'choices' => array(
        'wow bounceInLeft' => __('Bounce In Left', 'freelancer-resume'),
        'wow bounceInRight' => __('Bounce In Right', 'freelancer-resume'),
        'wow bounceInUp' => __('Bounce In Up', 'freelancer-resume'),
        'wow bounceInDown' => __('Bounce In Down', 'freelancer-resume'),
        'wow zoomIn' => __('Zoom In', 'freelancer-resume'),
        'wow zoomOut' => __('Zoom Out', 'freelancer-resume'),
        'wow fadeInDown' => __('Fade In Down', 'freelancer-resume'),
        'wow fadeInUp' => __('Fade In Up', 'freelancer-resume'),
        'wow fadeInLeft' => __('Fade In Left', 'freelancer-resume'),
        'wow fadeInRight' => __('Fade In Right', 'freelancer-resume'),
        'flip-up' => __('Flip Up', 'freelancer-resume')
    ),
    'section' => 'freelancerresume_featured_services_info_section',
));

// Section Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_maintaitle]',
    array(
        'default' => $freelancer_resume_default['featured_services_section_maintaitle'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_maintaitle]',
    array(
        'label' => __('Heading', 'freelancer-resume'),
        'section' => 'freelancerresume_featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_maintaitle]',
        'type' => 'text'
    )
);

// Section Sub-Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_subtitle]',
    array(
        'default' => $freelancer_resume_default['featured_services_section_subtitle'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_subtitle]',
    array(
        'label' => __('Sub Heading 1', 'freelancer-resume'),
        'section' => 'freelancerresume_featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_subtitle]',
        'type' => 'text'
    )
);
// Section Sub-Title
$wp_customize->add_setting(
    'theme_options[featured_services_section_subtitle1]',
    array(
        'default' => $freelancer_resume_default['featured_services_section_subtitle1'],
        'type' => 'theme_mod',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    'theme_options[featured_services_section_subtitle1]',
    array(
        'label' => __('Sub Heading 2', 'freelancer-resume'),
        'section' => 'freelancerresume_featured_services_info_section',
        'settings' => 'theme_options[featured_services_section_subtitle1]',
        'type' => 'text'
    )
);


$wp_customize->add_setting('featured_services_page_1', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_1', array(
    'label' => __('Select Page 1', 'freelancer-resume'),
    'section' => 'freelancerresume_featured_services_info_section',
    'type' => 'dropdown-pages',
)));

$wp_customize->add_setting('featured_services_page_2', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_2', array(
    'label' => __('Select Page 2', 'freelancer-resume'),
    'section' => 'freelancerresume_featured_services_info_section',
    'type' => 'dropdown-pages',
)));

$wp_customize->add_setting('featured_services_page_3', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_3', array(
    'label' => __('Select Page 3', 'freelancer-resume'),
    'section' => 'freelancerresume_featured_services_info_section',
    'type' => 'dropdown-pages',
)));

$wp_customize->add_setting('featured_services_page_4', array(
    'sanitize_callback' => 'absint',
));
$wp_customize->add_control(new WP_Customize_Control($wp_customize, 'featured_services_page_4', array(
    'label' => __('Select Page 4', 'freelancer-resume'),
    'section' => 'freelancerresume_featured_services_info_section',
    'type' => 'dropdown-pages',
)));
