<?php
/**
 * Default theme options.
 *
 * @package freelancer-resume
 */

if ( ! function_exists( 'freelancer_resume_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0
	 *
	 * @return array Default theme options.
	 */
function freelancer_resume_get_default_theme_options() {

	$freelancer_resume_defaults = array();
	

    // Front Page Content
	$freelancer_resume_defaults['enable_frontpage_content'] 		= true;

	// Slider Section	
	$freelancer_resume_defaults['enable_featured_slider_section']		    	= true;
	//$freelancer_resume_defaults['show_slider_colors']		    			= false;	
	$freelancer_resume_defaults['featured_slider_content_type']		    	= 'featured_slider_page';
	$freelancer_resume_defaults['featured_slider_category_readmore_text']		= esc_html__('Read More','freelancer-resume');
	$freelancer_resume_defaults['data_slick_speed']					    	= 1000;
	$freelancer_resume_defaults['data_slick_infinite']				    	= 1;
	$freelancer_resume_defaults['data_slick_dots']					    	= 1;
	$freelancer_resume_defaults['data_slick_autoplay']				    	= 1;
	$freelancer_resume_defaults['data_slick_draggable']				    	= 1;
	$freelancer_resume_defaults['data_slick_fade']					    	= 1;
	$freelancer_resume_defaults['number_of_featured_slider_items']	    	= 6;

	// Features Section
	$freelancer_resume_defaults['enable_featured_features_section']			= true;
	//$freelancer_resume_defaults['show_feature_colors']						= false;
	$freelancer_resume_defaults['number_of_featured_features_items']			= 6;
	$freelancer_resume_defaults['featured_features_column']					= 3;
	$freelancer_resume_defaults['featured_features_content_type']				= 'featured_features_page';
	$freelancer_resume_defaults['feture_section_excerpt']						= 25;
	

	// About Section	
	$freelancer_resume_defaults['freelancerresume_enable_featured_about_section']						= true;
    $freelancer_resume_defaults['about_image_show'] 									= true;
	$freelancer_resume_defaults['featured_about_section_aboutus_subheading']							= esc_html__('(Why Me)', 'freelancer-resume' );
	$freelancer_resume_defaults['featured_about_section_aboutus_heading']							= esc_html__('Web Designer & Developer Enthusiast', 'freelancer-resume' );
	$freelancer_resume_defaults['featured_about_section_aboutus_description']							= esc_html__('There are many variations of passages of Lorem Ipsum slightly believable.', 'freelancer-resume' );
	// $freelancer_resume_defaults['freelancer_resume_aboutus_satisfiedclients_num']							= esc_html__('299', 'freelancer-resume' );


	// service Section	

	$freelancer_resume_defaults['freelancerresume_enable_featured_services_section']			= true;
	$freelancer_resume_defaults['featured_services_section_maintaitle']	    = esc_html__( '(SERVICE)', 'freelancer-resume' );
	$freelancer_resume_defaults['featured_services_section_subtitle']	    	= esc_html__( 'Web Designer & Developer ', 'freelancer-resume' );
	$freelancer_resume_defaults['featured_services_section_subtitle1']	    	= esc_html__( 'Enthusiast', 'freelancer-resume' );
	$freelancer_resume_defaults['services_excerpt_mainpagelength']			= 11;




	// Inner Blog Page	
	$freelancer_resume_defaults['featured_bloginn_botton_text']				= esc_html__( 'Read More', 'freelancer-resume' );

	return $freelancer_resume_defaults;

}

endif;

/**
*  Get theme options
*/
if ( ! function_exists( 'freelancer_resume_get_option' ) ) :

	/**
	 * Get theme option
	 *
	 * @since 1.0
	 *
	 * @param string $key Option key.
	 * @return mixed Option value.
	 */
	function freelancer_resume_get_option( $key ) {

		$default_options = freelancer_resume_get_default_theme_options();
		if ( empty( $key ) ) {
			return;
		}

		$theme_options = (array)get_theme_mod( 'theme_options' );
		$theme_options = wp_parse_args( $theme_options, $default_options );

		$value = null;

		if ( isset( $theme_options[ $key ] ) ) {
			$value = $theme_options[ $key ];
		}

		return $value;

	}

endif;
