<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package freelancer-resume
 */

?>

<footer id="colophon" class="site-footer">
    <div class="footer-widgets-area mt-4 container">
        <?php
        $footer_sidebar_data = freelancer_resume_footer_sidebar_class();
        $footer_sidebar = $footer_sidebar_data['active_sidebar'];
        $footer_class = $footer_sidebar_data['class'];

        if (!empty($footer_sidebar)): ?>
            <div class="<?php echo esc_attr($footer_class); ?>">
                <?php foreach ($footer_sidebar as $sidebar): ?>
                    <div class="hentry">
                        <?php dynamic_sidebar($sidebar); ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>

        <div class="d-flex">
            <p><?php echo esc_html( get_theme_mod( 'freelancer_resume_foot_link_texts', __( 'Follow Us :', 'freelancer-resume' ) ) ); ?></p>
            <ul class="d-flex">
                <li>
                    <a href="<?php echo esc_url( get_theme_mod( 'freelancer_resume_featured_icon_url_footer1', '' ) ); ?>">
                        <i class="<?php echo esc_attr( get_theme_mod( 'freelancer_resume_foot_featured_icon_footer1', 'fa-brands fa-facebook-f' ) ); ?>"></i>
                    </a>
                </li>
                <li>
                    <a href="<?php echo esc_url( get_theme_mod( 'freelancer_resume_featured_icon_url_footer2', '' ) ); ?>">
                        <i class="<?php echo esc_attr( get_theme_mod( 'freelancer_resume_foot_featured_icon_footer2', 'fa-brands fa-twitter' ) ); ?>"></i>
                    </a>
                </li>
                <li>
                    <a href="<?php echo esc_url( get_theme_mod( 'freelancer_resume_featured_icon_url_footer3', '' ) ); ?>">
                        <i class="<?php echo esc_attr( get_theme_mod( 'freelancer_resume_foot_featured_icon_footer3', 'fa-brands fa-instagram' ) ); ?>"></i>
                    </a>
                </li>
                <li>
                    <a href="<?php echo esc_url( get_theme_mod( 'freelancer_resume_featured_icon_url_footer4', '' ) ); ?>">
                        <i class="<?php echo esc_attr( get_theme_mod( 'freelancer_resume_foot_featured_icon_footer4', 'fa-brands fa-pinterest' ) ); ?>"></i>
                    </a>
                </li>
            </ul>

        </div>
    </div>

    <div class="site-info mt-4">
        <div class="container position-relative">
            <h2>
                <?php 
                echo esc_html( 
                    get_theme_mod( 
                        'freelancer_resume_foot_themename', 
                        __( 'Have Any Project Idea In Your Mind?', 'freelancer-resume' ) 
                    ) 
                ); 
                ?>
            </h2>

        </div>
    </div><!-- .site-info -->

    <!-- Scroll to Top Button -->
    <?php if ( get_theme_mod( 'featured_scrooltopbtn_on_off', true ) ) : ?>
        <div class="scroll-to-top">
            <a href="#" id="scroll-to-top">
                <img src="<?php echo esc_url( get_template_directory_uri() . '/assets/images/copyrightimg.png' ); ?>" 
                    alt="<?php echo esc_attr__( 'Footer Image', 'freelancer-resume' ); ?>" />
            </a>
        </div>
    <?php endif; ?>

</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>