<section id="featured-banner">
    <div class="featured-banner">

        <?php
        $freelancer_resume_bannerbg_profile_img = get_theme_mod( 'freelancer_resume_bannerbg_profile_img' );
        if ( ! empty( $freelancer_resume_bannerbg_profile_img ) ) {
            echo '<img alt="' . esc_attr( get_the_title() ) . '" src="' . esc_url( $freelancer_resume_bannerbg_profile_img ) . '" style="width: 100%; height: 100%; position: absolute; top: 0; left: 0; bottom: 0; object-fit: cover; z-index: -1;" />';
        } else {
            echo '<img alt="' . esc_attr__( 'About us', 'freelancer-resume' ) . '" src="' . get_template_directory_uri() . '/assets/images/bannerbgimg.png" style="width: 100%; height: 100%; position: absolute; top: 0; left: 0; bottom: 0; object-fit: cover; z-index: -1;" />';
        }
        ?>

        <div class="">
            <div class="row">

                <div class="col-xl-5 offset-xl-1 col-lg-5 offset-lg-1 col-md-12 col-sm-12 bannercol6">
                    <div class="content">
                        <h3><?php echo esc_html( get_theme_mod( 'freelancer_resume_banner_subtitle', __( 'Hey There,', 'freelancer-resume' ) ) ); ?></h3>
                        <h2><?php echo esc_html( get_theme_mod( 'freelancer_resume_banner_profilenametext', __( 'I am Mikey', 'freelancer-resume' ) ) ); ?></h2>
                        <h4><?php echo esc_html( get_theme_mod( 'freelancer_resume_banner_designationtext', __( 'I design websites and apps', 'freelancer-resume' ) ) ); ?></h4>
                        <p><?php echo esc_html( get_theme_mod( 'freelancer_resume_banner_descriptiontext', __( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don’t look slightly believable.', 'freelancer-resume' ) ) ); ?></p>

                        <div class="d-flex mt-4">
                            <div class="gap1 d-flex">
                                <div class="read-more fadeInDownBig">
                                    <a href="<?php echo esc_url( get_theme_mod( 'freelancer_resume_header_buttonhiremelink', '#' ) ); ?>" class="btn1 btn-custom1 rounded1">
                                        <?php echo esc_html( get_theme_mod( 'freelancer_resume_header_buttonhiremetext', __( 'Hire Me', 'freelancer-resume' ) ) ); ?>
                                    </a>
                                </div>
                                <div class="corve"></div>
                                <div class="user-icon">
                                    <i class="fa-solid fa-user"></i>
                                </div>
                            </div>
                            <div class="sliderbut2 animated flipInY mx-2">
                                <a href="<?php echo esc_url( get_theme_mod( 'freelancer_resume_header_buttondownloadcvlink', '#' ) ); ?>" class="btn2 btn-custom1 rounded1">
                                    <?php echo esc_html( get_theme_mod( 'freelancer_resume_header_buttondownloadcvtext', __( 'Download CV', 'freelancer-resume' ) ) ); ?>
                                </a>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="col-xl-6 col-lg-6 col-md-12 col-sm-12">
                    <div class="mainimg">
                        <div class="profileimg">
                            <?php
                            $freelancer_resume_banner_profile_img = get_theme_mod( 'freelancer_resume_banner_profile_img' );
                            if ( ! empty( $freelancer_resume_banner_profile_img ) ) {
                                echo '<img alt="' . esc_attr( get_the_title() ) . '" src="' . esc_url( $freelancer_resume_banner_profile_img ) . '" />';
                            } else {
                                echo '<img alt="' . esc_attr__( 'About us', 'freelancer-resume' ) . '" src="' . get_template_directory_uri() . '/assets/images/bannerprofileimg.png" style="width: 100%; height: 100%; object-fit: cover;" />';
                            }
                            ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

</section>


<div class="container-fluid p-0">
    <div class="row faq-margin p-0">
        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 d-flex p-0">
            <div class="clientlogo d-flex scroller">
                <div class="owl-carousel d-flex scroller__inner">

                    <?php 
                    // Array of client items
                    $clients = [
                        [
                            'icon' => get_theme_mod( 'featured_icon_client1', 'fa-solid fa-recycle' ),
                            'text' => get_theme_mod( 'freelancer_resume_banner_skillsbar_text1', __( 'GRAPHIC DESIGN', 'freelancer-resume' ) ),
                        ],
                        [
                            'icon' => get_theme_mod( 'featured_icon_client2', 'fas fa-bookmark' ),
                            'text' => get_theme_mod( 'freelancer_resume_banner_skillsbar_text2', __( 'GRAPHIC DESIGN', 'freelancer-resume' ) ),
                        ],
                        [
                            'icon' => get_theme_mod( 'featured_icon_client3', 'fas fa-file' ),
                            'text' => get_theme_mod( 'freelancer_resume_banner_skillsbar_text3', __( 'GRAPHIC DESIGN', 'freelancer-resume' ) ),
                        ],
                        [
                            'icon' => get_theme_mod( 'featured_icon_client4', 'fas fa-paper-plane' ),
                            'text' => get_theme_mod( 'freelancer_resume_banner_skillsbar_text4', __( 'GRAPHIC DESIGN', 'freelancer-resume' ) ),
                        ],
                        [
                            'icon' => get_theme_mod( 'featured_icon_client5', 'fas fa-bookmark' ),
                            'text' => get_theme_mod( 'freelancer_resume_banner_skillsbar_text5', __( 'GRAPHIC DESIGN', 'freelancer-resume' ) ),
                        ],
                    ];

                    $effect_class = esc_attr( get_theme_mod( 'webnotick_featured_counters_onload_effects', 'wow zoomIn' ) );
                    $text_align = esc_attr( get_theme_mod( 'featured_slider1_box_align', 'left' ) );

                    foreach ( $clients as $client ) :
                    ?>
                        <article class="slider1-block <?php echo $effect_class; ?>" data-wow-duration="2s">
                            <div class="slider1box" style="text-align: <?php echo $text_align; ?>;">
                                <div class="slider1-icon d-flex">
                                    <i class="<?php echo esc_attr( $client['icon'] ); ?>"></i>
                                    <h4 class="slider1-title">
                                        <a href="#"><?php echo esc_html( $client['text'] ); ?></a>
                                    </h4>
                                </div>
                            </div>
                        </article>
                    <?php endforeach; ?>

                </div>
            </div>


            <script>
                const scrollers = document.querySelectorAll(".scroller");

                // If a user hasn't opted in for recuded motion, then we add the animation
                if (!window.matchMedia("(prefers-reduced-motion: reduce)").matches) {
                    addAnimation();
                }

                function addAnimation() {
                    scrollers.forEach((scroller) => {
                        // add data-animated="true" to every `.scroller` on the page
                        scroller.setAttribute("data-animated", true);

                        // Make an array from the elements within `.scroller-inner`
                        const scrollerInner = scroller.querySelector(".scroller__inner");
                        const scrollerContent = Array.from(scrollerInner.children);

                        // For each item in the array, clone it
                        // add aria-hidden to it
                        // add it into the `.scroller-inner`
                        scrollerContent.forEach((item) => {
                            const duplicatedItem = item.cloneNode(true);
                            duplicatedItem.setAttribute("aria-hidden", true);
                            scrollerInner.appendChild(duplicatedItem);
                        });
                    });
                }

            </script>
            <style>
                .scroller__inner {
                    /* padding-block: 1rem; */
                    display: flex;
                    flex-wrap: wrap;
                    gap: 1rem;
                }

                .scroller[data-animated="true"] {
                    overflow: hidden;
                }

                .scroller[data-animated="true"] .scroller__inner {
                    width: max-content;
                    flex-wrap: nowrap;
                    animation: scroll var(--_animation-duration, 40s) var(--_animation-direction, forwards) linear infinite;
                }

                .scroller[data-direction="right"] {
                    --_animation-direction: reverse;
                }

                .scroller[data-direction="left"] {
                    --_animation-direction: forwards;
                }

                .scroller[data-speed="fast"] {
                    --_animation-duration: 20s;
                }

                .scroller[data-speed="slow"] {
                    --_animation-duration: 60s;
                }

                @keyframes scroll {
                    to {
                        transform: translate(calc(-50% - 0.5rem));
                    }
                }
            </style>
        </div>
    </div>
</div>