<?php
/**
 * Template part for displaying About Section
 *
 *@package freelancer-resume
 */
$freelancer_resume_featured_about_section_aboutus_subheading = freelancer_resume_get_option('featured_about_section_aboutus_subheading');
$freelancer_resume_featured_about_section_aboutus_heading = freelancer_resume_get_option('featured_about_section_aboutus_heading');
$freelancer_resume_featured_about_section_aboutus_description = freelancer_resume_get_option('featured_about_section_aboutus_description');

?>
<?php 
if ( ! get_theme_mod( 'freelancerresume_enable_featured_about_section', true ) ) {
    return;
}
?>
<section id="featured-about">

    <div class="container-fluid p-0 my-5">
        <div class="row d-flex about-section-main">

            <!-- Left Image Column -->
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 justify-items-center col-div col-div1">
                <div class="about-img">
                    <div class="about-image">
                        <?php
                        $freelancer_resume_about_image1 = get_theme_mod('freelancer_resume_about_image1');
                        if ( ! empty( $freelancer_resume_about_image1 ) ) {
                            echo '<img alt="' . esc_attr( get_the_title() ) . '" src="' . esc_url( $freelancer_resume_about_image1 ) . '" />';
                        } else {
                            echo '<img alt="' . esc_attr__( 'About us', 'freelancer-resume' ) . '" src="' . get_template_directory_uri() . '/assets/images/about.png" />';
                        }
                        ?>
                    </div>

                    <!-- Stats Numbers -->
                    <div class="about-text-number">
                        <div class="col-xl-10 offset-xl-1 col-lg-10 offset-lg-1 col-md-10 offset-md-1 col-sm-11 offset-sm-1">
                            <div class="row padding-sm">

                                <div class="col-xl-4 col-lg-4 col-md-4 col-4">
                                    <div class="row back12">
                                        <h3 class="number" data-target="<?php echo absint( get_theme_mod( 'freelancer_resume_aboutus_satisfiedclients_num', 299 ) ); ?>">0</h3>
                                        <h4 class="text1"><?php echo esc_html( get_theme_mod( 'freelancer_resume_aboutus_satisfiedclients_text', __( 'Satisfied Clients', 'freelancer-resume' ) ) ); ?></h4>
                                    </div>
                                </div>

                                <div class="col-xl-4 col-lg-4 col-md-4 col-4">
                                    <div class="row back12">
                                        <h3 class="number" data-target="<?php echo absint( get_theme_mod( 'freelancer_resume_aboutus_successfulproject_num', 250 ) ); ?>">0</h3>
                                        <h4 class="text1"><?php echo esc_html( get_theme_mod( 'freelancer_resume_aboutus_successfulproject_text', __( 'Successful Project', 'freelancer-resume' ) ) ); ?></h4>
                                    </div>
                                </div>

                                <div class="col-xl-4 col-lg-4 col-md-4 col-4">
                                    <div class="row back12">
                                        <h3 class="number" data-target="<?php echo absint( get_theme_mod( 'freelancer_resume_aboutus_prodesign_num', 52 ) ); ?>">0</h3>
                                        <h4 class="text1"><?php echo esc_html( get_theme_mod( 'freelancer_resume_aboutus_prodesign_text', __( 'Pro design', 'freelancer-resume' ) ) ); ?></h4>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Text Column -->
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12 col-12 col-div col-div2 <?php echo esc_attr( get_theme_mod( 'freelancer_resume_featured_about_onload_effects', 'wow zoomIn' ) ); ?>">

                <div class="myside">
                    <div class="col-sm-12 col-12 img-h2">
                        <!-- Heading 1 -->
                        <h2 class="main-heaing"><?php echo esc_html( $freelancer_resume_featured_about_section_aboutus_subheading ); ?></h2>
                    </div>

                    <div class="col-sm-12 col-12 heading-2nd">
                        <!-- Heading 2 -->
                        <h2 class="sub-heaing1"><?php echo esc_html( $freelancer_resume_featured_about_section_aboutus_heading ); ?></h2>
                    </div>

                    <div class="col-sm-12 col-12 description">
                        <p><?php echo wp_kses_post( $freelancer_resume_featured_about_section_aboutus_description ); ?></p>
                    </div>

                    <div class="col-sm-12 col-12 heading-3nd">
                        <div class="row pt-3">
                            <div class="col-lg-6 col-md-6 col-sm-12 about-imgdiv">
                                <ul>
                                    <li><?php echo esc_html( get_theme_mod( 'freelancer_resume_aboutus_list1', __( 'Clean And Modern Website /App Designs', 'freelancer-resume' ) ) ); ?></li>
                                    <li><?php echo esc_html( get_theme_mod( 'freelancer_resume_aboutus_list2', __( 'Basic Coding Skills For Custom Features', 'freelancer-resume' ) ) ); ?></li>
                                </ul>
                            </div>
                            <div class="col-lg-6 col-md-6 col-sm-12 about-imgdiv">
                                <ul>
                                    <li><?php echo esc_html( get_theme_mod( 'freelancer_resume_aboutus_list3', __( 'Responsive And User-Friendly Layouts', 'freelancer-resume' ) ) ); ?></li>
                                    <li><?php echo esc_html( get_theme_mod( 'freelancer_resume_aboutus_list4', __( 'Fast Delivery With Clear Communication', 'freelancer-resume' ) ) ); ?></li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <div class="button mt-3">
                        <a href="<?php echo esc_url( get_theme_mod( 'freelancer_resume_aboutus_buttonhiremelink', '#' ) ); ?>" class="btn1 btn-custom1 rounded1">
                            <?php echo esc_html( get_theme_mod( 'freelancer_resume_aboutus_buttonhiremetext', __( 'Hire Me', 'freelancer-resume' ) ) ); ?>
                        </a>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const counters = document.querySelectorAll(".number");
    const speed = 100; // lower = faster

    const animateCounter = (counter) => {
        const target = +counter.getAttribute("data-target");
        let count = 0;
        const increment = Math.ceil(target / speed);

        const updateCount = () => {
            if (count < target) {
                count += increment;
                counter.innerText = count;
                setTimeout(updateCount, 30);
            } else {
                counter.innerText = target + " +";
            }
        };

        updateCount();
    };

    // Use IntersectionObserver to trigger only when visible
    const observer = new IntersectionObserver(
        (entries, observer) => {
            entries.forEach((entry) => {
                if (entry.isIntersecting) {
                    animateCounter(entry.target);
                    observer.unobserve(entry.target); // Run once
                }
            });
        },
        { threshold: 0.5 } // run when 50% visible
    );

    counters.forEach((counter) => {
        observer.observe(counter);
    });
});
</script>
