<?php

/**
 * Header Theme Options
 *
 * @package freelancer-resume
 */
$wp_customize->add_section('freelancer_resume_header_section', array(

	'title'      => esc_html__('Header Section', 'freelancer-resume'),
	'capability' => 'edit_theme_options',
	'panel' => 'freelancer_resume_theme_section_panel'

));

//  button text 
$wp_customize->add_setting( 'freelancer_resume_header_buttontext' , array(
    'default'   => 'Lets Work Together',   
    'sanitize_callback' => 'freelancer_resume_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'freelancer_resume_header_buttontext', array(   
    'label'      => esc_html__( 'Button Text', 'freelancer-resume' ),   
    'section'    => 'freelancer_resume_header_section',   
    'settings'   => 'freelancer_resume_header_buttontext',   
    'type' => 'text',         
) ) );


//  button url 
$wp_customize->add_setting( 'freelancer_resume_header_buttonurl' , array(
    'default'   => 'Lets Work Together',   
    'sanitize_callback' => 'freelancer_resume_sanitise_custom_texttitle',    
    ) );

    $wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'freelancer_resume_header_buttonurl', array(   
    'label'      => esc_html__( 'Button Link', 'freelancer-resume' ),   
    'section'    => 'freelancer_resume_header_section',   
    'settings'   => 'freelancer_resume_header_buttonurl',   
    'type' => 'text',         
) ) );

// ///////// Button Bg Color
$wp_customize->add_setting('header_button_bg_color', array(
    'default'   => '#F6F6F6',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_button_bg_color', array(
    'section' => 'freelancer_resume_header_section',
    'label'      => esc_html__('Button Background Color', 'freelancer-resume'),
    )));


    // ///////// Button Border Color
$wp_customize->add_setting('header_button_border_color', array(
    'default'   => '8px solid #C93CC1',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_button_border_color', array(
    'section' => 'freelancer_resume_header_section',
    'label'      => esc_html__('Button Border Color', 'freelancer-resume'),
    )));

    /////////// Button Border Color
$wp_customize->add_setting('header_button_text_color', array(
    'default'   => '#151606',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_button_text_color', array(
    'section' => 'freelancer_resume_header_section',
    'label'      => esc_html__('Button Text Color', 'freelancer-resume'),
    )));

    /////////// Menu Text Color
$wp_customize->add_setting('header_menu_text_color', array(
    'default'   => '#000000',
    'transport' => 'refresh',
    'sanitize_callback' => 'sanitize_hex_color',
    ));
  
    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_menu_text_color', array(
    'section' => 'freelancer_resume_header_section',
    'label'      => esc_html__('Menu Text Color', 'freelancer-resume'),
    )));
