<?php
/**
 * Footer Theme Options
 *
 * @package freelancer-resume
 */

$wp_customize->add_section( 'freelancer_resume_footer_section' , array(
	'title'      => esc_html__( 'Footer Section', 'freelancer-resume' ),
	'capability' => 'edit_theme_options',
	'panel' => 'freelancer_resume_theme_section_panel'
) );

// Theme Name
$wp_customize->add_setting('freelancer_resume_foot_themename', array(
    'default' => 'Have Any Project Idea In Your Mind?',
    'sanitize_callback' => 'freelancer_resume_sanitise_custom_texttitle',
));

$wp_customize->add_control('freelancer_resume_foot_themename', array(
    'label'    => __('Theme Name', 'freelancer-resume'),
    'section'  => 'freelancer_resume_footer_section',
    'settings' => 'freelancer_resume_foot_themename',
    'type'     => 'text',
));

// Author Name
$wp_customize->add_setting('freelancer_resume_foot_link_texts', array(
    'default' => 'Follow Us :',
    'sanitize_callback' => 'freelancer_resume_sanitise_custom_texttitle',
));

$wp_customize->add_control('freelancer_resume_foot_link_texts', array(
    'label'    => __('Footer Bottom Corner Icons Title', 'freelancer-resume'),
    'section'  => 'freelancer_resume_footer_section',
    'settings' => 'freelancer_resume_foot_link_texts',
    'type'     => 'text',
));

// Footer icons 1
$wp_customize->add_setting('freelancer_resume_foot_featured_icon_footer1', 
    array(
    'default'           => 'fa-brands fa-facebook-f',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('freelancer_resume_foot_featured_icon_footer1', 
    array(
    'label'       => __('Icon 1', 'freelancer-resume'),
    'section'     => 'freelancer_resume_footer_section',   
    'settings'    => 'freelancer_resume_foot_featured_icon_footer1',        
    'type'        => 'text'
));

// Footer icons 1 Url
$wp_customize->add_setting('freelancer_resume_featured_icon_url_footer1', 
    array(
    'default'           => ' ', 
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('freelancer_resume_featured_icon_url_footer1', 
    array(
    'label'       => __('Icon 1 Url', 'freelancer-resume'),
    'section'     => 'freelancer_resume_footer_section',   
    'settings'    => 'freelancer_resume_featured_icon_url_footer1',        
    'type'        => 'text'
));

// Footer icons 2
$wp_customize->add_setting('freelancer_resume_foot_featured_icon_footer2', 
    array(
    'default'           => 'fa-brands fa-twitter',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('freelancer_resume_foot_featured_icon_footer2', 
    array(
    'label'       => __('Icon 2', 'freelancer-resume'),
    'section'     => 'freelancer_resume_footer_section',   
    'settings'    => 'freelancer_resume_foot_featured_icon_footer2',        
    'type'        => 'text'
));

// Footer icons 2 Url
$wp_customize->add_setting('freelancer_resume_featured_icon_url_footer2', 
    array(
    'default'           => ' ', 
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('freelancer_resume_featured_icon_url_footer2', 
    array(
    'label'       => __('Icon 2 Url', 'freelancer-resume'),
    'section'     => 'freelancer_resume_footer_section',   
    'settings'    => 'freelancer_resume_featured_icon_url_footer2',        
    'type'        => 'text'
));

// Footer icons 3
$wp_customize->add_setting('freelancer_resume_foot_featured_icon_footer3', 
    array(
    'default'           => 'fa-brands fa-instagram',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('freelancer_resume_foot_featured_icon_footer3', 
    array(
    'label'       => __('Icon 3', 'freelancer-resume'),
    'section'     => 'freelancer_resume_footer_section',   
    'settings'    => 'freelancer_resume_foot_featured_icon_footer3',        
    'type'        => 'text'
));

// Footer icons 3 Url
$wp_customize->add_setting('freelancer_resume_featured_icon_url_footer3', 
    array(
    'default'           => ' ', 
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('freelancer_resume_featured_icon_url_footer3', 
    array(
    'label'       => __('Icon 3 Url', 'freelancer-resume'),
    'section'     => 'freelancer_resume_footer_section',   
    'settings'    => 'freelancer_resume_featured_icon_url_footer3',        
    'type'        => 'text'
));
// Footer icons 3
$wp_customize->add_setting('freelancer_resume_foot_featured_icon_footer4', 
    array(
    'default'           => 'fa-brands fa-pinterest',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('freelancer_resume_foot_featured_icon_footer4', 
    array(
    'label'       => __('Icon 3', 'freelancer-resume'),
    'section'     => 'freelancer_resume_footer_section',   
    'settings'    => 'freelancer_resume_foot_featured_icon_footer4',        
    'type'        => 'text'
));

// Footer icons 3 Url
$wp_customize->add_setting('freelancer_resume_featured_icon_url_footer4', 
    array(
    'default'           => ' ', 
    'sanitize_callback' => 'sanitize_text_field'
));
$wp_customize->add_control('freelancer_resume_featured_icon_url_footer4', 
    array(
    'label'       => __('Icon 3 Url', 'freelancer-resume'),
    'section'     => 'freelancer_resume_footer_section',   
    'settings'    => 'freelancer_resume_featured_icon_url_footer4',        
    'type'        => 'text'
));