<?php
/**
 * About Section options.
 *
 * @package freelancer-resume
 */

$freelancer_resume_default = freelancer_resume_get_default_theme_options();

$wp_customize->add_section(
    'freelancerresume_featured_banner_section',
    array(
        'title' => __('Banner Info', 'freelancer-resume'),
        'priority' => 1,
        'panel' => 'freelancer_resume_section_panel',
    )
);

// bg image
$wp_customize->add_setting( 'freelancer_resume_bannerbg_profile_img', array(  
    'sanitize_callback' => 'freelancer_resume_sanitise_custom_url'
    ));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'freelancer_resume_bannerbg_profile_img', array(
        'label'      => __( 'BG Image', 'freelancer-resume' ),
        'section'    => 'freelancerresume_featured_banner_section',
        'settings'   => 'freelancer_resume_bannerbg_profile_img',
)));

// sub title
$wp_customize->add_setting('freelancer_resume_banner_subtitle', 
    array(
    'default'           => __('Hey There,', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_banner_subtitle', 
    array(
    'label'       => __('Sub Title', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_banner_section',   
    'settings'    => 'freelancer_resume_banner_subtitle',           
    'type'        => 'text'
    )
);

// profilenametext
$wp_customize->add_setting('freelancer_resume_banner_profilenametext', 
    array(
    'default'           => __('I am Mikey', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_banner_profilenametext', 
    array(
    'label'       => __('Profile Name Text', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_banner_section',   
    'settings'    => 'freelancer_resume_banner_profilenametext',           
    'type'        => 'text'
    )
);

// designationtext
$wp_customize->add_setting('freelancer_resume_banner_designationtext', 
    array(
    'default'           => __('I design websites and apps', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_banner_designationtext', 
    array(
    'label'       => __('Designation Text', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_banner_section',   
    'settings'    => 'freelancer_resume_banner_designationtext',           
    'type'        => 'text'
    )
);

// descriptiontext
$wp_customize->add_setting('freelancer_resume_banner_descriptiontext', 
    array(
    'default'           => __('There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look slightly believable.', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_banner_descriptiontext', 
    array(
    'label'       => __('Description', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_banner_section',   
    'settings'    => 'freelancer_resume_banner_descriptiontext',           
    'type'        => 'text'
    )
);

// buttonhiremetext
$wp_customize->add_setting('freelancer_resume_header_buttonhiremetext', 
    array(
    'default'           => __('Hire Me', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_header_buttonhiremetext', 
    array(
    'label'       => __('Button Hire me Text', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_banner_section',   
    'settings'    => 'freelancer_resume_header_buttonhiremetext',           
    'type'        => 'text'
    )
);

// buttonhiremelink
$wp_customize->add_setting('freelancer_resume_header_buttonhiremelink', 
    array(
    'default'           => __('#', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control('freelancer_resume_header_buttonhiremelink', 
    array(
    'label'       => __('Button Hire me Link', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_banner_section',   
    'settings'    => 'freelancer_resume_header_buttonhiremelink',           
    'type'        => 'url'
    )
);

// buttondownloadcvtext
$wp_customize->add_setting('freelancer_resume_header_buttondownloadcvtext', 
    array(
    'default'           => __('Download CV', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_header_buttondownloadcvtext', 
    array(
    'label'       => __('Button Hire me Text', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_banner_section',   
    'settings'    => 'freelancer_resume_header_buttondownloadcvtext',           
    'type'        => 'text'
    )
);

// buttondownloadcvlink
$wp_customize->add_setting('freelancer_resume_header_buttondownloadcvlink', 
    array(
    'default'           => __('#', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control('freelancer_resume_header_buttondownloadcvlink', 
    array(
    'label'       => __('Button Hire me Link', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_banner_section',   
    'settings'    => 'freelancer_resume_header_buttondownloadcvlink',           
    'type'        => 'url'
    )
);

// profile image
$wp_customize->add_setting( 'freelancer_resume_banner_profile_img', array(  
    'sanitize_callback' => 'freelancer_resume_sanitise_custom_url'
    ));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'freelancer_resume_banner_profile_img', array(
        'label'      => __( 'Profile Image', 'freelancer-resume' ),
        'section'    => 'freelancerresume_featured_banner_section',
        'settings'   => 'freelancer_resume_banner_profile_img',
)));



// ========== ICON 1 ==========
$wp_customize->add_setting('featured_icon_client1', array(
    'default'           => 'fa-solid fa-recycle',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('featured_icon_client1', array(
    'label'    => __('Icon 1 (Font Awesome class)', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'featured_icon_client1',
    'type'     => 'text',
));

// Skillsbar text 1
$wp_customize->add_setting('freelancer_resume_banner_skillsbar_text1', array(
    'default'           => 'GRAPHIC DESIGN',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('freelancer_resume_banner_skillsbar_text1', array(
    'label'    => __('Skills Bar Text 1', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'freelancer_resume_banner_skillsbar_text1',
    'type'     => 'text',
));


// ========== ICON 2 ==========
$wp_customize->add_setting('featured_icon_client2', array(
    'default'           => 'fas fa-bookmark',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('featured_icon_client2', array(
    'label'    => __('Icon 2 (Font Awesome class)', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'featured_icon_client2',
    'type'     => 'text',
));

// Skillsbar text 2
$wp_customize->add_setting('freelancer_resume_banner_skillsbar_text2', array(
    'default'           => 'WEBSITE DEVELOPMENT',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('freelancer_resume_banner_skillsbar_text2', array(
    'label'    => __('Skills Bar Text 2', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'freelancer_resume_banner_skillsbar_text2',
    'type'     => 'text',
));


// ========== ICON 3 ==========
$wp_customize->add_setting('featured_icon_client3', array(
    'default'           => 'fas fa-file',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('featured_icon_client3', array(
    'label'    => __('Icon 3 (Font Awesome class)', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'featured_icon_client3',
    'type'     => 'text',
));

// Skillsbar text 3
$wp_customize->add_setting('freelancer_resume_banner_skillsbar_text3', array(
    'default'           => 'UI/UX DESIGN',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('freelancer_resume_banner_skillsbar_text3', array(
    'label'    => __('Skills Bar Text 3', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'freelancer_resume_banner_skillsbar_text3',
    'type'     => 'text',
));


// ========== ICON 4 ==========
$wp_customize->add_setting('featured_icon_client4', array(
    'default'           => 'fas fa-paper-plane',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('featured_icon_client4', array(
    'label'    => __('Icon 4 (Font Awesome class)', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'featured_icon_client4',
    'type'     => 'text',
));

// Skillsbar text 4
$wp_customize->add_setting('freelancer_resume_banner_skillsbar_text4', array(
    'default'           => 'SOCIAL MEDIA MANAGEMENT',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('freelancer_resume_banner_skillsbar_text4', array(
    'label'    => __('Skills Bar Text 4', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'freelancer_resume_banner_skillsbar_text4',
    'type'     => 'text',
));


// ========== ICON 5 ==========
$wp_customize->add_setting('featured_icon_client5', array(
    'default'           => 'fas fa-bookmark',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('featured_icon_client5', array(
    'label'    => __('Icon 5 (Font Awesome class)', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'featured_icon_client5',
    'type'     => 'text',
));

// Skillsbar text 5
$wp_customize->add_setting('freelancer_resume_banner_skillsbar_text5', array(
    'default'           => 'WORDPRESS EXPERT',
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',
    'sanitize_callback' => 'sanitize_text_field',
));
$wp_customize->add_control('freelancer_resume_banner_skillsbar_text5', array(
    'label'    => __('Skills Bar Text 5', 'freelancer-resume'),
    'section'  => 'freelancerresume_featured_banner_section',
    'settings' => 'freelancer_resume_banner_skillsbar_text5',
    'type'     => 'text',
));
