<?php
/**
 * About Section options.
 *
 * @package freelancer-resume
 */

$freelancer_resume_default = freelancer_resume_get_default_theme_options();

/** About Info section */
$wp_customize->add_section(
    'freelancerresume_featured_about_info_section',
    array(
        'title'    => __( 'About Info', 'freelancer-resume' ),      
        'priority' => 3,
        'panel'      => 'freelancer_resume_section_panel',       	
    )
);

// Enable Section
$wp_customize->add_setting('freelancerresume_enable_featured_about_section', 
	array(
	'default' 			=> $freelancer_resume_default['freelancerresume_enable_featured_about_section'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'freelancer_resume_sanitize_switch'
	)
);

$wp_customize->add_control('freelancerresume_enable_featured_about_section', 
	array(		
	'label' 	=> __('Enable Section', 'freelancer-resume'),
	'section' 	=> 'freelancerresume_featured_about_info_section',
	'settings'  => 'freelancerresume_enable_featured_about_section',
	'type' 		=> 'checkbox',	
	)
);

$wp_customize->add_setting('freelancer_resume_featured_about_onload_effects', array(
    'default' => 'wow zoomIn',
    'sanitize_callback' => 'freelancer_resume_sanitize_choices',
));

$wp_customize->add_control('freelancer_resume_featured_about_onload_effects', array(
    'label' => __('Box Onload Transition Effects', 'freelancer-resume'),
    'section' => 'freelancerresume_featured_about_info_section',
    'settings' => 'freelancer_resume_featured_about_onload_effects',
    'type' => 'select',
    'choices' => array(
        'wow bounceInLeft' => __('Bounce In Left', 'freelancer-resume'),
        'wow bounceInRight' => __('Bounce In Right', 'freelancer-resume'),
        'wow bounceInUp' => __('Bounce In Up', 'freelancer-resume'),
        'wow bounceInDown' => __('Bounce In Down', 'freelancer-resume'),
        'wow zoomIn' => __('Zoom In', 'freelancer-resume'),
        'wow zoomOut' => __('Zoom Out', 'freelancer-resume'),
        'wow fadeInDown' => __('Fade In Down', 'freelancer-resume'),
        'wow fadeInUp' => __('Fade In Up', 'freelancer-resume'),
        'wow fadeInLeft' => __('Fade In Left', 'freelancer-resume'),
        'wow fadeInRight' => __('Fade In Right', 'freelancer-resume'),
        'flip-up' => __('Flip Up', 'freelancer-resume'),
    ),
));


//Section Image
$wp_customize->add_setting( 'freelancer_resume_about_image1', array(  
    'sanitize_callback' => 'freelancer_resume_sanitise_custom_url'
    ));
$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'freelancer_resume_about_image1', array(
        'label'      => __( 'Section Image', 'freelancer-resume' ),
        'section'    => 'freelancerresume_featured_about_info_section',
        'settings'   => 'freelancer_resume_about_image1',
)));


  $wp_customize->add_setting(
    'freelancer_resume_aboutus_satisfiedclients_num',
    array(
        'default'           => '299',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);

$wp_customize->add_control(
    'freelancer_resume_aboutus_satisfiedclients_num',
    array(
        'label'    => __( 'Plan Number 1', 'freelancer-resume' ),
        'section'  => 'freelancerresume_featured_about_info_section',
        'settings' => 'freelancer_resume_aboutus_satisfiedclients_num',
        'type'     => 'text',
    )
);

// satisfiedclients text
$wp_customize->add_setting('freelancer_resume_aboutus_satisfiedclients_text', 
    array(
    'default'           => __('Satisfied Clients', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_aboutus_satisfiedclients_text', 
    array(
    'label'       => __('Satisfied Clients Text', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_about_info_section',   
    'settings'    => 'freelancer_resume_aboutus_satisfiedclients_text',           
    'type'        => 'text'
    )
);



  $wp_customize->add_setting(
    'freelancer_resume_aboutus_successfulproject_num',
    array(
        'default'           => '250',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);

$wp_customize->add_control(
    'freelancer_resume_aboutus_successfulproject_num',
    array(
        'label'    => __( 'Plan Number 2', 'freelancer-resume' ),
        'section'  => 'freelancerresume_featured_about_info_section',
        'settings' => 'freelancer_resume_aboutus_successfulproject_num',
        'type'     => 'text',
    )
);

// successfulproject text
$wp_customize->add_setting('freelancer_resume_aboutus_successfulproject_text', 
    array(
    'default'           => __('Successful Project', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_aboutus_successfulproject_text', 
    array(
    'label'       => __('Successful Project Text', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_about_info_section',   
    'settings'    => 'freelancer_resume_aboutus_successfulproject_text',           
    'type'        => 'text'
    )
);


  $wp_customize->add_setting(
    'freelancer_resume_aboutus_prodesign_num',
    array(
        'default'           => '52',
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field',
    )
);

$wp_customize->add_control(
    'freelancer_resume_aboutus_prodesign_num',
    array(
        'label'    => __( 'Plan Number 3', 'freelancer-resume' ),
        'section'  => 'freelancerresume_featured_about_info_section',
        'settings' => 'freelancer_resume_aboutus_prodesign_num',
        'type'     => 'text',
    )
);
// prodesign_text
$wp_customize->add_setting('freelancer_resume_aboutus_prodesign_text', 
    array(
    'default'           => __('Pro design', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_aboutus_prodesign_text', 
    array(
    'label'       => __('Pro Design Text', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_about_info_section',   
    'settings'    => 'freelancer_resume_aboutus_prodesign_text',           
    'type'        => 'text'
    )
);


// Section Title
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_subheading]', 
    array(
        'default'           => $freelancer_resume_default['featured_about_section_aboutus_subheading'],
        'type'              => 'theme_mod',
        'capability'        => 'edit_theme_options',	
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_subheading]', 
    array(
        'label'       => __('Sub Heading', 'freelancer-resume'),
        'section'     => 'freelancerresume_featured_about_info_section',   
        'settings'    => 'theme_options[featured_about_section_aboutus_subheading]',		
        'type'        => 'text'
    )
);


// // Section Title
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_heading]', 
	array(
	'default'           => $freelancer_resume_default['featured_about_section_aboutus_heading'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_heading]', 
	array(
	'label'       => __('Heading 1', 'freelancer-resume'),
	'section'     => 'freelancerresume_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_heading]',		
	'type'        => 'text'
	)
);

// // Section description
$wp_customize->add_setting('theme_options[featured_about_section_aboutus_description]', 
	array(
	'default'           => $freelancer_resume_default['featured_about_section_aboutus_description'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);
$wp_customize->add_control('theme_options[featured_about_section_aboutus_description]', 
	array(
	'label'       => __('Description', 'freelancer-resume'),
	'section'     => 'freelancerresume_featured_about_info_section',   
	'settings'    => 'theme_options[featured_about_section_aboutus_description]',		
	'type'        => 'text'
	)
);

// list1
$wp_customize->add_setting('freelancer_resume_aboutus_list1', 
    array(
    'default'           => __('Clean And Modern Website /App Designs', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_aboutus_list1', 
    array(
    'label'       => __('List 1', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_about_info_section',   
    'settings'    => 'freelancer_resume_aboutus_list1',           
    'type'        => 'text'
    )
);

// list2
$wp_customize->add_setting('freelancer_resume_aboutus_list2', 
    array(
    'default'           => __('Basic Coding Skills For Custom Features', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_aboutus_list2', 
    array(
    'label'       => __('List 2', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_about_info_section',   
    'settings'    => 'freelancer_resume_aboutus_list2',           
    'type'        => 'text'
    )
);

// list3
$wp_customize->add_setting('freelancer_resume_aboutus_list3', 
    array(
    'default'           => __('Responsive And User-Friendly Layouts', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_aboutus_list3', 
    array(
    'label'       => __('List 3', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_about_info_section',   
    'settings'    => 'freelancer_resume_aboutus_list3',           
    'type'        => 'text'
    )
);

// list4
$wp_customize->add_setting('freelancer_resume_aboutus_list4', 
    array(
    'default'           => __('Fast Delivery With Clear Communication', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_aboutus_list4', 
    array(
    'label'       => __('List 4', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_about_info_section',   
    'settings'    => 'freelancer_resume_aboutus_list4',           
    'type'        => 'text'
    )
);

// buttonhiremetext
$wp_customize->add_setting('freelancer_resume_aboutus_buttonhiremetext', 
    array(
    'default'           => __('Hire Me', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control('freelancer_resume_aboutus_buttonhiremetext', 
    array(
    'label'       => __('Button Hire me Text', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_about_info_section',   
    'settings'    => 'freelancer_resume_aboutus_buttonhiremetext',           
    'type'        => 'text'
    )
);

// buttonhiremelink
$wp_customize->add_setting('freelancer_resume_aboutus_buttonhiremelink', 
    array(
    'default'           => __('#', 'freelancer-resume'),
    'type'              => 'theme_mod',
    'capability'        => 'edit_theme_options',    
    'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control('freelancer_resume_aboutus_buttonhiremelink', 
    array(
    'label'       => __('Button Hire me Link', 'freelancer-resume'),
    'section'     => 'freelancerresume_featured_about_info_section',   
    'settings'    => 'freelancer_resume_aboutus_buttonhiremelink',           
    'type'        => 'url'
    )
);
