<?php
/**
 * freelancer-resume Theme Customizer
 *
 * @package freelancer-resume
 */

 // Custom Controls.
require get_template_directory() . '/inc/custom-control/custom-control.php';

// Sanitize callback.
require get_template_directory() . '/inc/customizer/sanitize-callback.php';

// Default
require get_template_directory() . '/inc/customizer/default.php';

// Load customize sanitize.
include get_template_directory() . '/inc/customizer/active-callback.php';


// Theme section.
// require get_template_directory() . '/inc/customizer/theme-section.php';

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function freelancer_resume_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'freelancer_resume_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'freelancer_resume_customize_partial_blogdescription',
			)
		);
	}
	// Front Page Link
	require get_template_directory() . '/inc/customizer/home-section.php';

	require get_template_directory() . '/inc/customizer/section-pro.php';

	// Theme Page Link
	require get_template_directory() . '/inc/customizer/theme-options.php';
}
add_action( 'customize_register', 'freelancer_resume_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function freelancer_resume_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function freelancer_resume_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function freelancer_resume_customize_preview_js() {
	wp_enqueue_script( 'freelancer_resume_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), FREELANCERRESUME_S_VERSION, true );
}
add_action( 'customize_preview_init', 'freelancer_resume_customize_preview_js' );

/**
 *
 */
function freelancer_resume_customize_backend_scripts() {

	wp_enqueue_style( 'freelancer-resume-fontawesome-all', get_template_directory_uri() . '/assets/css/all.css' );

	wp_enqueue_style( 'freelancer-resume-main-css', get_template_directory_uri() . '/assets/css/output.css' );

	wp_enqueue_style( 'freelancer-resume-admin-customizer-style', get_template_directory_uri() . '/inc/customizer/css/customizer-style.css' );

	// Enqueue main customizer JS
	wp_enqueue_script(
		'freelancer-resume-admin-customizer',
		get_template_directory_uri() . '/inc/customizer/js/customizer-script.js',
		array( 'jquery', 'customize-controls' ),
		'20151215',
		true
	);

	// Enqueue the controls script
	wp_enqueue_script(
		'freelancer-resume-admin-customizer-control',
		get_template_directory_uri() . '/inc/customizer/js/customize-controls.js',
		array( 'jquery', 'customize-controls' ),
		'1.0',
		true
	);

	// Fix: Localize the customizer params for use in JS
	wp_localize_script(
		'freelancer-resume-admin-customizer-control',
		'freelancer_resume_customizer_params',
		array(
			'ajaxurl' => admin_url( 'admin-ajax.php' ),
		)
	);
}
add_action( 'customize_controls_enqueue_scripts', 'freelancer_resume_customize_backend_scripts', 10 );

/**
 * Enqueue the stylesheet.
 */
function freelancer_resume_customizer_stylesheet() {

    wp_register_style( 'freelancer-resume-admin-css', get_template_directory_uri() . '/inc/customizer/css/customize-controls.css', NULL, NULL, 'all' );
    wp_enqueue_style( 'freelancer-resume-admin-css' );
}
add_action( 'customize_controls_print_styles', 'freelancer_resume_customizer_stylesheet' );

///////////////////////////// customize  color 

function freelancer_resume_customize_css() {
    $custom_css = "

		#site-navigation .rounded1{
			background-color:" . esc_attr( get_theme_mod( 'header_button_bg_color', '#F6F6F6' ) ) . ";
		}

		#site-navigation .rounded1{
			border-left:8px solid" . esc_attr( get_theme_mod( 'header_button_border_color', '#C93CC1' ) ) . ";
			border-right:8px solid" . esc_attr( get_theme_mod( 'header_button_border_color', '#C93CC1' ) ) . ";
		}

		#site-navigation .rounded1{
			color:" . esc_attr( get_theme_mod( 'header_button_text_color', '#151606' ) ) . ";
		}

		#site-navigation ul li a{
			color:" . esc_attr( get_theme_mod( 'header_menu_text_color', '#000000' ) ) . ";
		}

        .slider-inner-mainbox .slider-socialicon .socialicon {
            color: " . esc_attr( get_theme_mod( 'social_icon_color', '#000000' ) ) . ";
        }

		.widget .widget-title, .widget .wp-block-heading, .widget .wp-block-search__label{
			color: " . esc_attr( get_theme_mod( 'freelancer_resume_sidebar_Hedingcolor', '#C63DC1' ) ) . ";
		}
		.wp-block-search__button{
			background-color: " . esc_attr( get_theme_mod( 'freelancer_resume_sidebar_searchbtncolor', '#C63DC1' ) ) . " !important;
		}

		.wp-block-search__button{
			color: " . esc_attr( get_theme_mod( 'freelancer_resume_sidebar_searchtextcolor', '#C63DC1' ) ) . " !important;
		}
		.widget:nth-child(even) {
			background-color: " . esc_attr( get_theme_mod( 'freelancer_resume_sidebar_headingbgcolor', '#ECF5FF' ) ) . " !important;
		}
		.widget .wp-block-heading{
			border-bottom: 2px solid " . esc_attr( get_theme_mod( 'freelancer_resume_sidebar_headingborder', '#C63DC1' ) ) . ";
		}

        #featured-slider .entry-container h4 {
            color: " . esc_attr( get_theme_mod( 'slider_title_color', '#000000' ) ) . ";
        }
        #featured-slider .entry-container .content {
            color: " . esc_attr( get_theme_mod( 'slider_subtitle_color', '#000000' ) ) . ";
        }
        #featured-slider .content a,
        #featured-slider code,
        .wp-block-buttons .wp-block-button__link,
        .singlepage #submit {
            background: " . esc_attr( get_theme_mod( 'slider_readmore_color', '#000000' ) ) . ";
            color: " . esc_attr( get_theme_mod( 'slider_readmoretxt_color', '#ffffff' ) ) . " !important;
        }
        #featured-slider .slick-dots li {
            background: " . esc_attr( get_theme_mod( 'slider_slickdot_color', '#cccccc' ) ) . ";
        }
        #featured-slider .slick-dots li.slick-active {
            background: " . esc_attr( get_theme_mod( 'slider_activeslickdot_color', '#000000' ) ) . ";
        }
        #featured-slider .sliderbut1 a {
            color: " . esc_attr( get_theme_mod( 'slider_buttontext1_color', '#ffffff' ) ) . ";
        }
        #featured-slider .sliderbut1 {
            background: " . esc_attr( get_theme_mod( 'slider_buttonbg1_color', '#000000' ) ) . ";
        }
        #featured-slider .sliderbut2 a {
            color: " . esc_attr( get_theme_mod( 'slider_buttontext2_color', '#ffffff' ) ) . ";
        }
        #featured-slider .sliderbut2 {
            background: " . esc_attr( get_theme_mod( 'slider_buttonbg2_color', '#000000' ) ) . ";
        }
        .featured-whatweoffer {
            background: " . esc_attr( get_theme_mod( 'whatweoffer_background_color', '#ffffff' ) ) . ";
        }
        .featured-whatweoffer .head-title {
            color: " . esc_attr( get_theme_mod( 'whatweoffer_title_color', '#000000' ) ) . ";
        }
        .featured-whatweoffer .head-subtitle {
            color: " . esc_attr( get_theme_mod( 'whatweoffer_subtitle_color', '#666666' ) ) . ";
        }
        .featured-whatweoffer .title a {
            color: " . esc_attr( get_theme_mod( 'whatweoffer_cardtitle_color', '#000000' ) ) . ";
        }
    ";

    // Add inline CSS to your already enqueued main stylesheet
    wp_add_inline_style( 'freelancer-resume-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'freelancer_resume_customize_css' );
