<?php
/**
 * freelancer-resume functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package freelancer-resume
 */

if ( ! defined( 'FREELANCERRESUME_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'FREELANCERRESUME_S_VERSION', '2.0' );
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function freelancer_resume_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on freelancer-resume, use a find and replace
		* to change 'freelancer-resume' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'freelancer-resume', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/**
 * Enable support for Post Thumbnails on posts and pages.
 *
 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
 */
	add_theme_support('post-thumbnails');


	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'freelancer-resume' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'freelancer_resume_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'freelancer_resume_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $freelancer_resume_content_width_global
 */
function freelancer_resume_content_width() {
	$GLOBALS['freelancer_resume_content_width_global'] = apply_filters( 'freelancer_resume_content_width', 640 );
}
add_action( 'after_setup_theme', 'freelancer_resume_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function freelancer_resume_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'freelancer-resume' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'freelancer-resume' ),
			 'before_widget' => '<div id="%1$s" class="widget %2$s  wow bounceInUp">',
			'after_widget' => '</div>',
			'before_title' => '<div class="widget-contain"> <h4 class="widget-title">',
			'after_title' => '</h4> </div>',
		)
	);
	// Footer Sidebar
register_sidebar(
	array(
		'name' => sprintf(esc_html__('Footer %d', 'freelancer-resume'), 1),
		'id' => 'footer-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));
register_sidebar(
	array(
		'name' => sprintf(esc_html__('Footer %d', 'freelancer-resume'), 2),
		'id' => 'footer-2',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));
register_sidebar(
	array(
		'name' => sprintf(esc_html__('Footer %d', 'freelancer-resume'), 3),
		'id' => 'footer-3',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));
register_sidebar(
	array(
		'name' => sprintf(esc_html__('Footer %d', 'freelancer-resume'), 4),
		'id' => 'footer-4',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h2 class="widget-title">',
		'after_title' => '</h2>',
	));
}
add_action( 'widgets_init', 'freelancer_resume_widgets_init' );

/**
 * Register custom fonts.
 */
function freelancer_resume_fonts_url()
{
	$fonts_url = '';
	$fonts = array();
	$subsets = 'latin,latin-ext';

	/* translators: If there are characters in your language that are not supported by Lora, translate this to 'off'. Do not translate into your own language. */
	if ('off' !== _x('on', 'Lora: on or off', 'freelancer-resume')) {
		$fonts[] = 'Lora:400,600,700';
	}

	if ('off' !== _x('on', 'Space Grotesk: on or off', 'freelancer-resume')) {
		$fonts[] = 'Space Grotesk:300,400,500,600,700';
	}

	if ($fonts) {
		$fonts_url = add_query_arg(
			array(
				'family' => urlencode(implode('|', $fonts)),
				'subset' => urlencode($subsets),
			), 'https://fonts.googleapis.com/css');
	}

	return esc_url_raw($fonts_url);
}

/**
 * Function that returns if the menu is sticky
 */
if (!function_exists('freelancer_resume_sticky_header')):
    function freelancer_resume_sticky_header()
    {
        $is_sticky = get_theme_mod('freelancer_resume_sticky_header', false);

        if ($is_sticky == false):
            return 'not-sticky';
        else:
            return 'is-sticky-on';
        endif;
    }
endif;

/**
 * Enqueue scripts and styles.
 */
function freelancer_resume_scripts() {
	wp_enqueue_style( 'freelancer-resume-style', get_stylesheet_uri(), array(), FREELANCERRESUME_S_VERSION );
	wp_style_add_data( 'freelancer-resume-style', 'rtl', 'replace' );

	wp_enqueue_style('freelancer-resume-fontawesome-css', get_stylesheet_directory_uri() . "/assets/css/all.css", '', FREELANCERRESUME_S_VERSION);
	wp_enqueue_style('freelancer-resume-responsive.css', get_stylesheet_directory_uri() . "/assets/css/responsive.css", '', FREELANCERRESUME_S_VERSION);
	wp_enqueue_style('freelancer-resume-animate.css', get_stylesheet_directory_uri() . "/assets/css/animate.css", '', FREELANCERRESUME_S_VERSION);
	wp_enqueue_style('freelancer-resume-output.css', get_stylesheet_directory_uri() . "/assets/css/output.css", '', FREELANCERRESUME_S_VERSION);
	wp_enqueue_style('freelancer-resume-blocks.css', get_stylesheet_directory_uri() . "/assets/css/blocks.css", '', FREELANCERRESUME_S_VERSION);
	wp_enqueue_style('freelancer-resume-bootstrap.css', get_stylesheet_directory_uri() . "/assets/css/bootstrap.css", '', FREELANCERRESUME_S_VERSION);
	wp_enqueue_style('freelancer-resume-slick.css', get_stylesheet_directory_uri() . "/assets/css/slick.css", '', FREELANCERRESUME_S_VERSION);
	wp_enqueue_style('freelancer-resume-pe-customize-controls.css', get_stylesheet_directory_uri() . "/assets/css/pe-customize-controls.css", '', FREELANCERRESUME_S_VERSION);
	wp_enqueue_style('freelancer-resume-swiper-bundle.css', get_stylesheet_directory_uri() . "/assets/css/swiper-bundle.css", '', FREELANCERRESUME_S_VERSION);
	
	wp_enqueue_script( 'freelancer-resume-navigation', get_template_directory_uri() . '/js/navigation.js', array(), FREELANCERRESUME_S_VERSION, true );
	wp_enqueue_script( 'freelancer-resume-all.js', get_template_directory_uri() . '/assets/js/all.js', array(), FREELANCERRESUME_S_VERSION, true );	
	wp_enqueue_script( 'freelancer-resume-custom.js', get_template_directory_uri() . '/assets/js/custom.js',array('jquery'), FREELANCERRESUME_S_VERSION, true );
	wp_enqueue_script( 'freelancer-resume-bootstrap.bundle.js', get_template_directory_uri() . '/assets/js/bootstrap.bundle.js', array(), FREELANCERRESUME_S_VERSION, true );
	wp_enqueue_script( 'freelancer-resume-slick.js', get_template_directory_uri() . '/assets/js/slick.js', array(), FREELANCERRESUME_S_VERSION, true );
	wp_enqueue_script( 'freelancer-resume-swiper-bundle.js', get_template_directory_uri() . '/assets/js/swiper-bundle.js', array(), FREELANCERRESUME_S_VERSION, true );
	wp_enqueue_script( 'freelancer-resume-slider-control.js', get_template_directory_uri() . '/assets/js/slider-control.js', array(), FREELANCERRESUME_S_VERSION, true );

    // Init script
    wp_add_inline_script('wow-js', 'new WOW().init();');

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'freelancer_resume_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';


/**
 * Custom functions that act independently of the theme templates.
 */
// require get_template_directory() . '/inc/extras.php';
if ( ! function_exists( 'freelancer_resume_the_excerpt' ) ) :

	function freelancer_resume_the_excerpt( $length = 0, $post_obj = null ) {

		global $post;

		if ( is_null( $post_obj ) ) {
			$post_obj = $post;
		}

		$length = absint( $length );

		if ( 0 === $length ) {
			return;
		}

		$source_content = $post_obj->post_content;

		if ( ! empty( $post_obj->post_excerpt ) ) {
			$source_content = $post_obj->post_excerpt;
		}

		$source_content = preg_replace( '`\[[^\]]*\]`', '', $source_content );
		$trimmed_content = wp_trim_words( $source_content, $length, '&hellip;' );
		return $trimmed_content;

	}

endif;
/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}
////////////////////////////////////////////////////////////////////////////////////////////////////////
// Integer sanitization
if ( ! function_exists( 'freelancer_resume_sanitize_integer' ) ) {
    function freelancer_resume_sanitize_integer( $input ) {
        return (int) $input;
    }
}
function freelancer_resume_customizer_script() {
    wp_enqueue_script(
        'freelancer_resume-customizer-script',
        get_template_directory_uri() . '/assets/js/customizer-button.js',
        ['customize-controls'],
        '1.0',
        true
    );
}
add_action( 'customize_controls_enqueue_scripts', 'freelancer_resume_customizer_script' );

// ... Your other functions

if ( ! function_exists( 'freelancer_resume_footer_sidebar_class' ) ) {
function freelancer_resume_footer_sidebar_class() {
$data = array();
$active_sidebar = array();
$count = 0;

if ( is_active_sidebar( 'footer-1' ) ) {
  $active_sidebar[] = 'footer-1';
  $count++;
}
if ( is_active_sidebar( 'footer-2' ) ) {
  $active_sidebar[] = 'footer-2';
  $count++;
}
if ( is_active_sidebar( 'footer-3' ) ) {
  $active_sidebar[] = 'footer-3';
  $count++;
}
if ( is_active_sidebar( 'footer-4' ) ) {
  $active_sidebar[] = 'footer-4';
  $count++;
}

$class = 'grid xl:grid-cols-4 lg:grid-cols-4 md:grid-cols-2 sm:grid-cols-1 gap-16';

$data['active_sidebar'] = $active_sidebar;
$data['class'] = $class;

return $data;
}
}

function freelancer_resume_sanitize_choices($input, $setting) {
    $choices = $setting->manager->get_control($setting->id)->choices;
    return (array_key_exists($input, $choices)) ? $input : $setting->default;
}



// blog sidebar image {recent Post} 

class freelancer_resume_Custom_Recent_Posts_Widget extends WP_Widget_Recent_Posts
{
	public function widget($args, $instance)
	{
		if (!isset($args['widget_id'])) {
			$args['widget_id'] = $this->id;
		}

		$title = (!empty($instance['title'])) ? $instance['title'] : __('Recent Posts', 'freelancer-resume');
		$title = apply_filters('widget_title', $title, $instance, $this->id_base);

		$query_args = [
			'posts_per_page' => !empty($instance['number']) ? absint($instance['number']) : 5,
			'post_status' => 'publish',
			'no_found_rows' => true,
			'ignore_sticky_posts' => true,
		];

		$recent_posts = new WP_Query(apply_filters('widget_posts_args', $query_args));

		if (!$recent_posts->have_posts()) {
			return;
		}
		?>

		<?php echo $args['before_widget']; ?>
		<?php if ($title) {
			echo $args['before_title'] . $title . $args['after_title'];
		} ?>
		<ul>
			<?php foreach ($recent_posts->posts as $recent_post): ?>
				<?php
				$post_title = get_the_title($recent_post->ID);
				$title = (!empty($post_title)) ? $post_title : __('(No Title)', 'freelancer-resume');
				$thumbnail = get_the_post_thumbnail($recent_post->ID, 'thumbnail');
				$post_date = get_the_date('F j, Y', $recent_post->ID); // Get post date
				?>
				<li>
					<?php if ($thumbnail): ?>
						<a class="img" href="<?php echo get_permalink($recent_post->ID); ?>">
							<?php echo $thumbnail; ?>
						</a>
					<?php endif; ?>
					<a class="img-content" href="<?php echo get_permalink($recent_post->ID); ?>">
						<h1> <?php echo $title; ?> </h1>

						<div class="clearfix"></div> <!-- Display post date -->
						<span class="post-date"><?php echo $post_date; ?></span>

					</a>

				</li>
			<?php endforeach; ?>
		</ul>
		<?php echo $args['after_widget']; ?>

		<?php
	}
}

function freelancer_resume_register_custom_recent_posts_widget()
{
	unregister_widget('WP_Widget_Recent_Posts');
	register_widget('freelancer_resume_Custom_Recent_Posts_Widget');
}
add_action('widgets_init', 'freelancer_resume_register_custom_recent_posts_widget');
