<?php
/**
 * Post Settings
 *
 * @package Fred
 */

// Add new section
$wp_customize->add_section( 'post_section', array(
  'title'                => esc_html__( 'Post Settings', 'fred' ),
  'priority'             => 28,
) );

// Sidebar
$wp_customize->add_setting( 'post_sidebar', array(
  'default'              => 'right',
  'sanitize_callback'    => 'vs_sanitize_sidebar',
) );
$wp_customize->add_control( 'post_sidebar', array(
  'label'                => esc_html__( 'Sidebar', 'fred' ),
  'section'              => 'post_section',
  'type'                 => 'radio',
  'choices'              => array(
    'right'              => esc_html__( 'Right Sidebar', 'fred' ),
    'left'               => esc_html__( 'Left Sidebar', 'fred' ),
    'disabled'           => esc_html__( 'No Sidebar', 'fred' ),
  ),
) );

// Display about the author
$wp_customize->add_setting( 'post_about_author', array(
  'default'              => 0,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_about_author', array(
  'label'                => esc_html__( 'Display about the author', 'fred' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Display prev next links
$wp_customize->add_setting( 'post_prev_next', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_prev_next', array(
  'label'                => esc_html__( 'Display prev next links', 'fred' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Heading
$wp_customize->add_setting( 'post_heading_post_meta', array(
  'sanitize_callback'    => 'esc_html',
) );
$wp_customize->add_control( new vs_customize_control_heading( $wp_customize, 'post_heading_post_meta', array(
  'label'                => esc_html__( 'Post Meta', 'fred' ),
  'section'              => 'post_section',
) ) );

// Display Author
$wp_customize->add_setting( 'post_author', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_author', array(
  'label'                => esc_html__( 'Display Author', 'fred' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Display Date
$wp_customize->add_setting( 'post_date', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_date', array(
  'label'                => esc_html__( 'Display Date', 'fred' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Display Categorys
$wp_customize->add_setting( 'post_categorys', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_categorys', array(
  'label'                => esc_html__( 'Display Categorys', 'fred' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Display Comments
$wp_customize->add_setting( 'post_comments', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_comments', array(
  'label'                => esc_html__( 'Display Comments', 'fred' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

// Display Tags
$wp_customize->add_setting( 'post_tags', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_tags', array(
  'label'                => esc_html__( 'Display Tags', 'fred' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );

if ( class_exists( 'Post_Views_Counter' ) ) {
  // Display Post Views
  $wp_customize->add_setting( 'post_post_views', array(
    'default'              => 0,
    'sanitize_callback'    => 'vs_sanitize_checkbox',
  ) );
  $wp_customize->add_control( 'post_post_views', array(
    'label'                => esc_html__( 'Display Post Views', 'fred' ),
    'section'              => 'post_section',
    'type'                 => 'checkbox',
  ) );
}

// Display Reading Time
$wp_customize->add_setting( 'post_reading_time', array(
  'default'              => 0,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'post_reading_time', array(
  'label'                => esc_html__( 'Display Reading Time', 'fred' ),
  'section'              => 'post_section',
  'type'                 => 'checkbox',
) );
