<?php
/**
 * Archive Settings
 *
 * @package Fred
 */

// Add new section
$wp_customize->add_section( 'archive_section', array(
  'title'                => esc_html__( 'Archive Settings', 'fred' ),
  'priority'             => 27,
) );

// Sidebar
$wp_customize->add_setting( 'archive_sidebar', array(
  'default'              => 'right',
  'sanitize_callback'    => 'vs_sanitize_sidebar',
) );
$wp_customize->add_control( 'archive_sidebar', array(
  'label'                => esc_html__( 'Sidebar', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'radio',
  'choices'              => array(
    'right'              => esc_html__( 'Right Sidebar', 'fred' ),
    'left'               => esc_html__( 'Left Sidebar', 'fred' ),
    'disabled'           => esc_html__( 'No Sidebar', 'fred' ),
  ),
) );

// Display preview images
$wp_customize->add_setting( 'archive_preview_image', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'archive_preview_image', array(
  'label'                => esc_html__( 'Display preview images', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'checkbox',
) );

// Post Summary
$wp_customize->add_setting( 'archive_summary', array(
  'default'              => 'excerpt',
  'sanitize_callback'    => 'vs_sanitize_summary',
) );
$wp_customize->add_control( 'archive_summary', array(
  'label'                => esc_html__( 'Post Summary', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'radio',
  'choices'              => array(
    'excerpt'            => esc_html__( 'Use Excerpts', 'fred' ),
    'content'            => esc_html__( 'Use Read More Tag', 'fred' ),
  ),
) );

// Excerpt Length (Number Of Words)
$wp_customize->add_setting( 'archive_excerpt_length', array(
  'default'              => 50,
  'sanitize_callback'    => 'vs_sanitize_number',
) );
$wp_customize->add_control( new vs_customize_number_control( $wp_customize, 'archive_excerpt_length', array(
  'label'                => esc_html__( 'Excerpt Length (Number of Words)', 'fred' ),
  'section'              => 'archive_section',
) ) );

// Pagination
$wp_customize->add_setting( 'archive_pagination_type', array(
  'default'              => 'load-more',
  'sanitize_callback'    => 'vs_sanitize_pagination_type',
) );
$wp_customize->add_control( 'archive_pagination_type', array(
  'label'                => esc_html__( 'Pagination', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'radio',
  'choices'              => array(
    'standard'           => esc_html__( 'Standard', 'fred' ),
    'navigation'         => esc_html__( 'Navigation', 'fred' ),
    'load-more'          => esc_html__( 'Load More Button', 'fred' ),
    'infinite'           => esc_html__( 'Infinite Load', 'fred' ),
  ),
) );

// Heading
$wp_customize->add_setting( 'archive_heading_post_meta', array(
  'sanitize_callback'    => 'esc_html',
) );
$wp_customize->add_control( new vs_customize_control_heading( $wp_customize, 'archive_heading_post_meta', array(
  'label'                => esc_html__( 'Post Meta', 'fred' ),
  'section'              => 'archive_section',
) ) );

// Display Author
$wp_customize->add_setting( 'archive_author', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'archive_author', array(
  'label'                => esc_html__( 'Display Author', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'checkbox',
) );

// Display Date
$wp_customize->add_setting( 'archive_date', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'archive_date', array(
  'label'                => esc_html__( 'Display Date', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'checkbox',
) );

// Display Categorys
$wp_customize->add_setting( 'archive_categorys', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'archive_categorys', array(
  'label'                => esc_html__( 'Display Categorys', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'checkbox',
) );

// Display Comments
$wp_customize->add_setting( 'archive_comments', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'archive_comments', array(
  'label'                => esc_html__( 'Display Comments', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'checkbox',
) );

// Display Tags
$wp_customize->add_setting( 'archive_tags', array(
  'default'              => 1,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'archive_tags', array(
  'label'                => esc_html__( 'Display Tags', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'checkbox',
) );

if ( class_exists( 'Post_Views_Counter' ) ) {
  // Display Post Views
  $wp_customize->add_setting( 'archive_post_views', array(
    'default'              => 0,
    'sanitize_callback'    => 'vs_sanitize_checkbox',
  ) );
  $wp_customize->add_control( 'archive_post_views', array(
    'label'                => esc_html__( 'Display Post Views', 'fred' ),
    'section'              => 'archive_section',
    'type'                 => 'checkbox',
  ) );
}

// Display Reading Time
$wp_customize->add_setting( 'archive_reading_time', array(
  'default'              => 0,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'archive_reading_time', array(
  'label'                => esc_html__( 'Display Reading Time', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'checkbox',
) );

// Display Read More
$wp_customize->add_setting( 'archive_read_more', array(
  'default'              => 0,
  'sanitize_callback'    => 'vs_sanitize_checkbox',
) );
$wp_customize->add_control( 'archive_read_more', array(
  'label'                => esc_html__( 'Display Read More', 'fred' ),
  'section'              => 'archive_section',
  'type'                 => 'checkbox',
) );
