<?php
/**
 * Social links
 *
 * @package Fred
 */

if ( ! function_exists( 'vs_social_links' ) ) {
  /**
   * Social Links
   */
  function vs_social_links() {
    $social_url = array();
    $social_list = array(
'facebook',
'twitter',
'instagram',
'pinterest',
'youtube',
'telegram',
'vimeo',
'soundcloud',
'spotify',
'dribbble',
'behance',
'github',
'ok',
'vk',
'xing',
'linkedin',
'twitch',
'flickr',
'snapchat',
'medium',
'weibo',
'wechat',
'tumblr',
'reddit',
'bloglovin',
'rss'
    );
    foreach ( $social_list as $social_list_value ) {
      $social_url[$social_list_value] = get_theme_mod( 'social_' . $social_list_value );
    }
    $social_url_empty = true;
    foreach ( $social_url as $social_url_key => $social_url_value ) {
      if ( $social_url_value ) {
        $social_url_empty = false;
        break;
      }
    }
    if ( ! $social_url_empty ) {
      ?>
      <div class="social-links-wrap">
      <?php
      foreach ( $social_url as $social_url_key => $social_url_value ) {
        if ( $social_url_value ) {
          ?>
          <a href="<?php echo esc_url( $social_url_value ); ?>" target="_blank" rel="nofollow"><i class="vs-icon vs-icon-<?php echo esc_attr( $social_url_key ); ?>"></i></a>
          <?php
        }
      }
      ?>
      </div>
      <?php
    }
  }
}
