<?php
/**
 * Recommended and Required Theme Plugins functions.
 *
 * @package Fred
 */

/**
 * The function sets the default options to plugins.
 *
 * Set Post Views Counter location to manual.
 * Set Yoast SEO separator between breadcrumbs.
 *
 * @param string $plugin Plugin name.
 */
function vs_plugin_set_options( $plugin ) {
  if ( 'post-views-counter' === $plugin ) {
    // Get display options.
    $display_options = get_option( 'post_views_counter_settings_display' );
    // Set position value.
    $display_options['position'] = 'manual';
    // Update options.
    update_option( 'post_views_counter_settings_display', $display_options );
  }

  if ( 'wp-seo' === $plugin ) {
    // Get display options.
    $display_options = get_option( 'wpseo_titles' );
    // Set position value.
    $display_options['breadcrumbs-sep'] = '<span class="vs-separator"></span>';
    // Update options.
    update_option( 'wpseo_titles', $display_options );
  }
}

/**
 * Hook into activated_plugin action.
 *
 * @param string $plugin Plugin path to main plugin file with plugin data.
 */
function vs_activated_plugin( $plugin ) {
  // Check if PVC constant is defined, use it to get PVC path anc compare to activated plugin.
  if ( 'post-views-counter/post-views-counter.php' === $plugin ) {
    vs_plugin_set_options( 'post-views-counter' );
  }

  // Check if WPSEO constant is defined, use it to get WPSEO path anc compare to activated plugin.
  if ( 'wordpress-seo/wp-seo.php' === $plugin ) {
    vs_plugin_set_options( 'wp-seo' );
  }
}
add_action( 'activated_plugin', 'vs_activated_plugin' );

/**
 * Hook into after_switch_theme action.
 */
function vs_activated_theme() {
  vs_plugin_set_options( 'post-views-counter' );
  vs_plugin_set_options( 'wp-seo' );
}
add_action( 'after_switch_theme', 'vs_activated_theme' );
