/**
 * Theme name: Fred
 */

( function( $ ) {
  'use strict';

/**
 * AJAX Load More
 */
if ( typeof vs_ajax_pagination !== 'undefined' ) {
  $( '.post-archive' ).append( '<div class="ajax-navigation"><button class="load-more">' + vs_ajax_pagination.translation.load_more + '</button></div>' );
  
  var query_data = $.parseJSON( vs_ajax_pagination.query_data ),
    infinite = $.parseJSON( query_data.infinite_load ),
    button = $( '.ajax-navigation .load-more' ),
    page = 2,
    loading = false,
    scrollHandling = {
      allow: infinite,
      reallow: function() {
        scrollHandling.allow = true;
      },
      delay: 400
    };
}

function vs_ajax_get_posts() {
  loading = true;

  button.addClass( 'loading' );
  var data = {
    action: 'vs_ajax_load_more',
    page: page,
    posts_per_page: vs_ajax_pagination.posts_per_page,
    query_data: vs_ajax_pagination.query_data,
    _ajax_nonce: vs_ajax_pagination.nonce,
  };

  var vs_pagination_url;
  if ( 'ajax_restapi' === vs_ajax_pagination.type ) {
    vs_pagination_url = vs_ajax_pagination.rest_url;
  } else {
    vs_pagination_url = vs_ajax_pagination.url;
  }

  $.post( vs_pagination_url, data, function( res ) {
    if ( res.success ) {

      var data = $( res.data.content );
      if ( data.length ) {
        var vsAppendEnd = function() {
          $( document.body ).trigger( 'post-load' );
          if ( $( '#fb-root' ).length ) {
            FB.XFBML.parse();
          }
          button.removeClass( 'loading' );
          page = page + 1;
          loading = false;
        };
        if ( $( '.post-archive .archive-main' ).hasClass( 'archive-masonry' ) ) {
          data.imagesLoaded( function() {
            $( '.post-archive .archive-main' ).colcade( 'append', data );
            vsAppendEnd();
          } );
        } else {
          $( '.post-archive .archive-main' ).append( data );
          vsAppendEnd();
        }
      }
      if ( res.data.posts_end || !data.length ) {
        $( '.ajax-navigation' ).remove();
      }
    } else {
    }
  } ).fail( function( xhr, textStatus, e ) {
  } );
}

if ( typeof vs_ajax_pagination !== 'undefined' ) {
  $( window ).scroll( function() {
    if ( button.length && !loading && scrollHandling.allow ) {
      scrollHandling.allow = false;
      setTimeout( scrollHandling.reallow, scrollHandling.delay );
      var offset = $( button ).offset().top - $( window ).scrollTop();
      if ( 4000 > offset ) {
        vs_ajax_get_posts();
      }
    }
  } );

  $( 'body' ).on( 'click', '.load-more', function() {
    if ( !loading ) {
      vs_ajax_get_posts();
    }
  } );
}

/**
 * Homepage Image Slider
 */
$( '.homepage-image-slider-container .carousel-items' ).imagesLoaded( function( instance ) {

  $( instance.elements ).each( function( index, el ) {

    $( el ).flickity( {
      cellAlign: 'left',
      wrapAround: true,
      autoPlay: false,
      adaptiveHeight: false,
      prevNextButtons: false,
      pageDots: true,
      autoPlay: vsLocalize.homepage_image_slider_autoplay == 1 ? parseInt(vsLocalize.homepage_image_slider_timeout) : false,
    } );

    if ( $( el ).data('flickity').slides.length == 1 ) {
      $( '.homepage-image-slider-container .carousel-items .flickity-page-dots' ).css( "display", "none" );
      $( '.homepage-image-slider-container .carousel-items .flickity-viewport' ).css( "cursor", "auto" );
    }

  } );

  $( '.homepage-image-slider-container .carousel-items .flickity-viewport' ).css( "height", vsLocalize.homepage_image_slider_height );

} );

/**
 * Navigation Sidebar
 */
$.fn.responsiveNav = function() {
  this.removeClass( 'menu-item-expanded' );
  if ( this.prev().hasClass( 'submenu-visible' ) ) {
    this.prev().removeClass( 'submenu-visible' ).slideUp( 350 );
    this.parent().removeClass( 'menu-item-expanded' );
  } else {
    this.parent().parent().find( '.menu-item .sub-menu' ).removeClass( 'submenu-visible' ).slideUp( 350 );
    this.parent().parent().find( '.menu-item-expanded' ).removeClass( 'menu-item-expanded' );
    this.prev().toggleClass( 'submenu-visible' ).hide().slideToggle( 350 );
    this.parent().toggleClass( 'menu-item-expanded' );
  }
};

function navigation_sidebar( e ) {
  $( '.widget_nav_menu .menu-item-has-children' ).each( function( e ) {
    $( this ).append( '<span></span>' );
    $( '> span', this ).on( 'click', function( e ) {
      e.preventDefault();
      $( this ).responsiveNav();
    } );
    if ( '#' === $( '> a', this ).attr( 'href' ) ) {
      $( '> a', this ).on( 'click', function( e ) {
        e.preventDefault();
        $( this ).next().next().responsiveNav();
      } );
    }
  } );
}

$( document ).ready( function( e ) {
  navigation_sidebar( e );
} );

/**
 * Offcanvas
 */
$( '.toggle-offcanvas, .site-overlay' ).on( 'click', function( e ) {
  e.preventDefault();

  if ( !$( 'body' ).hasClass( 'offcanvas-active' ) ) {
    $( 'body' ).addClass( 'offcanvas-transition' );
  } else {
    setTimeout( function() {
      $( 'body' ).removeClass( 'offcanvas-transition' );
    }, 400 );
  }

  $( 'body' ).toggleClass( 'offcanvas-active' );
} );

/**
 * Scroll To Top
 */

( function( $ ) {

  $( document ).ready( function() {

    $( window ).scroll( function() {
      var offset = 400;

      if ( $( this ).scrollTop() > offset ) {
        $( '.vs-scroll-to-top' ).addClass( 'vs-active' );
      } else {
        $( '.vs-scroll-to-top' ).removeClass( 'vs-active' );
      }
    } );

    $( '.vs-scroll-to-top' ).on( 'click', function() {

      $( 'body, html' ).animate( {
        scrollTop: 0
      }, 400 );

      return false;
    } );
  } );

} )( jQuery );

} )( jQuery );
