<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package FrannaMag
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php if ( is_archive() ) : ?>

		<div class="blog-content">

			<?php if ( has_post_thumbnail() ) : ?>
				<div class="img-container">
					<a href="<?php the_permalink(); ?>">
						<?php frannamag_post_thumbnail(); ?>
					</a>
				</div>
			<?php endif; ?>

			<div class="text-container">

				<div class="entry-meta">
					<?php
						frannamag_posted_on();
						frannamag_posted_by();
					?>
					<span>
						&nbsp;<i class="bi bi-chat-dots"></i> <a href="<?php comments_link(); ?>"><?php comments_number("0", "1", "%"); ?></a>
					</span>
				</div><!-- .entry-meta -->

				<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>

				<div class="entry-summary">
					<?php
						the_excerpt(
							sprintf(
								wp_kses(
									/* translators: %s: Name of current post. Only visible to screen readers */
									__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'frannamag' ),
									array(
										'span' => array(
											'class' => array(),
										),
									)
								),
								wp_kses_post( get_the_title() )
							)
						);
					?>
				</div><!-- .entry-summary -->

			</div><!-- .text-container -->

		</div><!-- .blog-content -->

	<?php else: ?>

		<div class="blog-content">

			<?php if ( has_post_thumbnail() ) : ?>
				<div class="img-container">
					<?php if( is_singular() ): ?>
						<?php frannamag_post_thumbnail(); ?>
					<?php else: ?>
						<a href="<?php the_permalink(); ?>">
							<?php frannamag_post_thumbnail(); ?>
						</a>
					<?php endif; ?>
				</div>
			<?php endif; ?>

			<div class="text-container">

				<div class="entry-meta">
					<?php
						frannamag_posted_on();
						frannamag_posted_by();
					?>
					<span>
						&nbsp;<i class="bi bi-chat-dots"></i> <a href="<?php comments_link(); ?>"><?php comments_number("0", "1", "%"); ?></a>
					</span>
				</div><!-- .entry-meta -->

				<?php
					if ( is_singular() ) :
						the_title( '<h2 class="entry-title">', '</h2>' );

						// Social share Buttons
						if( get_theme_mod( 'frannamag_social_share_display_setting', true ) ):
							do_action( 'frannamag_social_share_content' );
						endif;
						
					else :
						the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
					endif;
				?>

				<?php if( is_singular() ): ?>
					<div class="entry-content">
						<?php
							the_content(
								sprintf(
									wp_kses(
										/* translators: %s: Name of current post. Only visible to screen readers */
										__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'frannamag' ),
										array(
											'span' => array(
												'class' => array(),
											),
										)
									),
									wp_kses_post( get_the_title() )
								)
							);

							wp_link_pages(
								array(
									'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'frannamag' ),
									'after'  => '</div>',
								)
							);
						?>
					</div><!-- .entry-summary -->

					<div class="post-entry-footer">
						<?php frannamag_entry_footer(); ?>
					</div>

				<?php else: ?>
					<div class="entry-summary">
						<?php
							the_excerpt(
								sprintf(
									wp_kses(
										/* translators: %s: Name of current post. Only visible to screen readers */
										__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'frannamag' ),
										array(
											'span' => array(
												'class' => array(),
											),
										)
									),
									wp_kses_post( get_the_title() )
								)
							);
						?>
					</div><!-- .entry-summary -->

				<?php endif; ?>

			</div><!-- .text-container -->

		</div><!-- .blog-content -->

	<?php endif; ?>

</article><!-- #post-<?php the_ID(); ?> -->
