<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package FrannaMag
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="archive-content">

		<div class="text-container">

			<?php
				the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
			?>

			<?php if( 'page' !== get_post_type() ) : ?>
				<div class="entry-meta">
					<?php
					frannamag_posted_on();
					frannamag_posted_by();
					?>
				</div><!-- .entry-meta -->
			<?php endif; ?>

			<div class="entry-summary">
				<?php
					the_excerpt(
						sprintf(
							wp_kses(
								/* translators: %s: Name of current post. Only visible to screen readers */
								__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'frannamag' ),
								array(
									'span' => array(
										'class' => array(),
									),
								)
							),
							wp_kses_post( get_the_title() )
						)
					);
				?>
			</div><!-- .entry-summary -->

			<div class="entry-footer">
				<?php frannamag_entry_footer(); ?>
			</div>

		</div>

	</div><!-- .archive-content -->
	
</article><!-- #post-<?php the_ID(); ?> -->
