<?php 
    $home_layout    =   get_theme_mod( 'frannamag_home_layout_setting', '1' );
?>

<?php if( $home_layout && $home_layout == '2' ): ?>

    <?php
        $post_args  =   array(
            'posts_per_page'    =>  1
        );

        $home_layout_post   =   new WP_Query( $post_args );
    ?>

    <?php if( $home_layout_post->have_posts() ): ?>
        <?php while( $home_layout_post->have_posts() ) : $home_layout_post->the_post(); ?>
            <!-- Home content Banner -->
            <div class="widget-banner">

                <?php if( has_post_thumbnail() ): ?>
                    <div class="img-container">
                        <a href="<?php the_permalink(); ?>">
                            <?php frannamag_post_thumbnail(); ?>
                        </a>
                    </div>
                <?php else: ?>
                    <div class="img-container">
                        <a href="<?php the_permalink(); ?>">
                            <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/dist/images/bg-image-100x550.jpg">
                        </a>
                    </div>
                <?php endif; ?>

                <div class="text-container">

                    <div class="entry-meta">
                        <?php
                            frannamag_posted_on();
                            frannamag_posted_by();
                        ?>
                        <span>
                            &nbsp;<i class="bi bi-chat-dots"></i> <a href="<?php comments_link(); ?>"><?php comments_number("0", "1", "%"); ?></a>
                        </span>
                    </div><!-- .entry-meta -->
                    <h2 class="entry-title">
                        <a href="<?php the_permalink(); ?>">
                            <?php the_title(); ?>
                        </a>
                    </h2>

                    <div class="entry-summary">
                        <?php the_excerpt(); ?>
                    </div>

                </div>

            </div>
        <?php endwhile; wp_reset_postdata(); ?>
    <?php endif; ?>

<?php elseif( $home_layout && $home_layout == '3' ): ?>

    <?php
        $post_args  =   array(
            'posts_per_page'    =>  3
        );

        $home_layout_post   =   new WP_Query( $post_args );
    ?>

    <?php if( $home_layout_post->have_posts() ): ?>
    <!-- Home Grid 2 columns -->
    <div class="home-grid">
        <div class="home-grid-2-col-container">

            <?php while( $home_layout_post->have_posts() ) : $home_layout_post->the_post(); ?>
                <div class="grid-2-col-content">

                    <div class="widget-grid-2-col">

                        <?php if( has_post_thumbnail() ): ?>
                            <div class="img-container">
                                <a href="<?php the_permalink(); ?>">
                                    <?php frannamag_post_thumbnail(); ?>
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="img-container">
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/dist/images/bg-image-100x550.jpg">
                                </a>
                            </div>
                        <?php endif; ?>

                        <div class="text-container">

                            <div class="entry-meta">
                                <?php
                                    frannamag_posted_on();
                                    frannamag_posted_by();
                                ?>
                            </div><!-- .entry-meta -->
                            <h2 class="entry-title">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h2>

                            <div class="entry-summary">
                                <?php the_excerpt(); ?>
                            </div>

                        </div>

                    </div>

                </div>
            <?php endwhile; wp_reset_postdata(); ?>

        </div><!-- .home-grid-2-col-container -->
    </div><!-- .home-grid -->
    <?php endif; ?>

<?php elseif( $home_layout && $home_layout == '4' ): ?>

    <?php
        $post_args  =   array(
            'posts_per_page'    =>  3
        );

        $home_layout_post   =   new WP_Query( $post_args );
    ?>

    <?php if( $home_layout_post->have_posts() ): ?>
        <!-- Home Grid three columns -->
        <div class="home-grid">

            <div class="home-grid-3-col-container">

                <?php while( $home_layout_post->have_posts() ) : $home_layout_post->the_post(); ?>
                    <div class="widget-grid-3-col">

                        <?php if( has_post_thumbnail() ): ?>
                            <div class="img-container">
                                <a href="<?php the_permalink(); ?>">
                                    <?php frannamag_post_thumbnail(); ?>
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="img-container">
                                <a href="<?php the_permalink(); ?>">
                                    <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/dist/images/bg-image-100x550.jpg">
                                </a>
                            </div>
                        <?php endif; ?>

                        <div class="text-container">

                            <div class="entry-meta">
                                <?php
                                    frannamag_posted_on();
                                    frannamag_posted_by();
                                ?>
                            </div><!-- .entry-meta -->
                            <h2 class="entry-title">
                                <a href="<?php the_permalink(); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h2>

                        </div>

                    </div>
                <?php endwhile; wp_reset_postdata(); ?>

            </div><!-- .home-grid-3-col-container -->
            
        </div><!-- .home-grid -->
    <?php endif; ?>

<?php endif; ?>
