<?php
/**
 * Load TGMPA Class File
 */
if ( ! file_exists( get_template_directory() . '/plugins/class-tgm-plugin-activation.php' ) ) {
    // File does not exist... return an error.
    return new WP_Error( 'class-tgm-plugin-activation-missing', __( 'It appears the class-tgm-plugin-activation.php file may be missing.', 'frannamag' ) );
} else {
    // File exists... require it.
    get_template_part( 'plugins/class-tgm-plugin-activation' );
}

/**
 * Plugin File Load
 */
function frannamag_register_required_plugins() {

    $plugins    =   array(
        
        array(
            'name'                  =>  esc_html__( 'Regenerate Thumbnails', 'frannamag' ),
            'slug'                  =>  'regenerate-thumbnails',
            'required'              =>  false
        )
    );

    $config = array(
		'id'           => 'frannamag-tgmpa',         
		'default_path' => '',                     
		'menu'         => 'tgmpa-install-plugins',
		'has_notices'  => true,                   
		'dismissable'  => true,                   
		'dismiss_msg'  => '',                     
		'is_automatic' => false,                  
		'message'      => '',                     
	);

    tgmpa( $plugins, $config );

}
add_action( 'tgmpa_register', 'frannamag_register_required_plugins' );