<?php
if ( ! function_exists( 'frannamag_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function frannamag_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on FrannaMag, use a find and replace
		 * to change 'frannamag' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'frannamag', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// Register Custom image size
		add_image_size( 'frannamag-thumbnail', 1000, 550, true );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'primary'		=>	esc_html__( 'Primary', 'frannamag' ),
				'top-header'	=>	esc_html__( 'Top Header', 'frannamag' ),
				'footer'		=>	esc_html__( 'Footer', 'frannamag' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'frannamag_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 100,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);

        /**
         * Add Supports for Gutenberg
         */
        add_theme_support( 'align-wide' );
	}
endif;
add_action( 'after_setup_theme', 'frannamag_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function frannamag_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'frannamag_content_width', 640 );
}
add_action( 'after_setup_theme', 'frannamag_content_width', 0 );

/**
 * Add Theme Starter content
 */
if( ! function_exists( 'frannamag_starter_content_setup' ) ):

	function frannamag_starter_content_setup() {
		$starter_content = array(
			'widgets'     => array(
				'sidebar-1'                         => array(
					'search', 
					'recent-posts', 
					'categories', 
					'text_business_info', 
					'text_about',
				),
				'frontpage-sidebar'    => array(
					'frontpage_category_one',
					array(
						'post_style_1',
						array(
							'type'		=>	'latest',
							'title'		=>	esc_html__( 'Recent Posts', 'frannamag' ),
							'number'	=>	5
						),
					),
					'frontpage_category_two',
					array(
						'post_style_2',
						array(
							'type'		=>	'latest',
							'title'		=>	esc_html__( 'Recent Posts', 'frannamag' ),
							'number'	=>	2
						),
					),
					'frontpage_category_three',
					array(
						'post_style_3',
						array(
							'type'		=>	'latest',
							'title'		=>	esc_html__( 'Recent Posts', 'frannamag' ),
							'number'	=>	5
						),
					),
				),
			),

			// Specify the core-defined pages to create and add custom thumbnails to some of them.
			'posts'       => array(
				'sample'            => array(
					'post_type'    	=> 'page',
					'post_title'   	=> esc_html__( 'Sample Page', 'frannamag' ),
				),
				'home'	=>	array(
					'template'	=>	'inc/templates/front-starter-content.php'
				),
				'contact',
				'blog',
				'about',
				// Create posts
				'ut-non-enim-eleifend-felis-vestibulum' => array(
					'post_type'    => 'post',
					'post_title'   => esc_html__( 'Ut non enim eleifend felis vestibulum', 'frannamag' ),
					'post_content' => esc_html__('Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet iaculis, ipsum. Etiam iaculis nunc ac metus. In turpis. Pellentesque auctor neque nec urna. Praesent ac massa at ligula laoreet iaculis.', 'frannamag'),
					'thumbnail'    => '{{nature-1000x550.jpg}}',
				),
				'vestibulum-fringilla-pede-sit-amet' => array(
					'post_type'    => 'post',
					'post_title'   => esc_html__( 'Vestibulum fringilla pede sit amet', 'frannamag'),
					'post_content' => esc_html__( 'Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet iaculis, ipsum. Etiam iaculis nunc ac metus. In turpis. Pellentesque auctor neque nec urna. Praesent ac massa at ligula laoreet iaculis.', 'frannamag'),
					'thumbnail'    => '{{image-desk-coffee-cup.jpg}}',
				),
				'vestibulum-fringilla-pede-eleifend-felis' => array(
					'post_type'    => 'post',
					'post_title'   => esc_html__( 'Vestibulum fringilla pede eleifend felis', 'frannamag'),
					'post_content' => esc_html__( 'Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet iaculis, ipsum. Etiam iaculis nunc ac metus. In turpis. Pellentesque auctor neque nec urna. Praesent ac massa at ligula laoreet iaculis.', 'frannamag'),
					'thumbnail'    => '{{nature-1000x550.jpg}}',
				),
				'nam-quam-nunc-blandit-praesent-venenatis'           => array(
					'post_type'    => 'post',
					'post_title'   => esc_html__( 'Nam quam nunc blandit Praesent venenatis', 'frannamag' ),
					'post_content' => esc_html__( 'The cover block lets you add text on top of images or videos. This blocktype has several alignment options, and you can also align or center the text inside the block.', 'frannamag' ),
					'thumbnail'    => '{{image-desk-coffee-cup.jpg}}',
				),
				'nam-quam-nunc-blandit-vel-praesent' => array(
					'post_type'    => 'post',
					'post_title'   => esc_html__( 'Nam quam nunc blandit vel praesent', 'frannamag' ),
					'post_content' => esc_html__( 'Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet iaculis, ipsum. Etiam iaculis nunc ac metus. In turpis. Pellentesque auctor neque nec urna. Praesent ac massa at ligula laoreet iaculis.', 'frannamag' ),
					'thumbnail'    => '{{nature-1000x550.jpg}}',
				),
				'praesent-venenatis-metus-at-tortor'           => array(
					'post_type'    => 'post',
					'post_title'   => esc_html__( 'Praesent venenatis metus at tortor', 'frannamag' ),
					'post_content' => esc_html__( 'Getting to know better the frannamag WordPress theme for your Blog. Use this to design a nice looking News or magazine website', 'frannamag' ),
					'thumbnail'    => '{{image-desk-coffee-cup.jpg}}',
				),
			),

			'options'    => array(
				'blogname'        	=> ucfirst( 'frannamag' ),
				'blogdescription' 	=> ucfirst( 'frannamag' ).' '.esc_html__( ' Theme starter content', 'frannamag' ),
				'show_on_front' 	=> 'page',
				'page_on_front' 	=> '{{home}}',
				'page_for_posts' 	=> '{{blog}}',
			),

			// Create the custom image attachments used as post thumbnails for pages.
			'attachments' => array(
				'image-desk-coffee-cup.jpg'              	=> array(
					'post_title' => esc_html__( 'Desk Coffee Cup', 'frannamag' ),
					'file'       => 'dist/images/image-desk-coffee-cup.jpg',
				),
				'nature-1000x550.jpg'              	=> array(
					'post_title' => esc_html__( 'Nature Image', 'frannamag' ),
					'file'       => 'dist/images/nature-1000x550.jpg',
				)
			),

			// Set up nav menus for each of the two areas registered in the theme.
			'nav_menus'  	=> array(
				// Assign a menu to the "primary" location.
				'primary' 	=> array(
					'name'  => esc_html__( 'Primary', 'frannamag' ),
					'items' => array(
						'page_home'		=>	array(
							'type'		=>	'post_type',
							'object'	=>	'page',
							'object_id'	=>	'{{home}}',
						),
						'page_sample'   => array(
							'type'      => 'post_type',
							'object'    => 'page',
							'object_id' => '{{sample}}',
						),
						'page_blog',
						'page_about',
						'page_contact',
					),
				),
			),

		);
		$starter_content = apply_filters( 'frannamag_starter_content', $starter_content );

		add_theme_support( 'starter-content', $starter_content );
	}

endif;
add_action( 'after_setup_theme', 'frannamag_starter_content_setup' );