<?php
/**
 * This returns markup before main content, main content markup and markup after main content
 *
 * @package frannamag
 */

/**
 * Return content before Main content
 */
if ( ! function_exists( 'frannamag_before_content' ) ) :
    function frannamag_before_content() {
    ?>
        <?php if( class_exists( 'WooCommerce' ) && (is_cart() || is_checkout() || is_account_page() ) ): ?>
            <div class="content-wrapper fullwidth">
        <?php elseif( is_page_template( 'fullwidth-container.php' ) ): ?>
            <div class="content-wrapper fullwidth">
        <?php else: ?>
            <div class="content-wrapper">
        <?php endif; ?>
            <main id="primary" class="content-area">

    <?php
    }
endif;
add_action( 'frannamag_before_content_display', 'frannamag_before_content' );

/**
 * Return main content
 */
if ( ! function_exists( 'frannamag_main_content' ) ) :
    function frannamag_main_content() {
    ?>

        <?php if ( is_page() ) : ?>

            <div class="single-post-container">

                <?php if ( is_front_page() ) : ?>

                    <?php
                        if( is_active_sidebar( 'frontpage-sidebar' ) ) {
                            dynamic_sidebar( 'frontpage-sidebar' );
                        }
                    ?>
                
                <?php else : ?>

                    <?php
                    while ( have_posts() ) :
                        the_post();

                        get_template_part( 'template-parts/content', 'page' );

                        get_template_part( 'inc/templates/template-comments' );

                    endwhile; // End of the loop.
                    ?>

                <?php endif; ?>

            </div><!-- .single-post-container -->

        <?php elseif ( is_home() ) : ?>

            <?php get_template_part( 'template-parts/content', 'blog-layout' ); ?>

        <?php elseif ( is_archive() ) : ?>

            <?php
				if ( have_posts() ) : ?>

                    <header class="page-header">
                        <?php
                            the_archive_title( '<h1 class="page-title">', '</h1>' );
                            the_archive_description( '<div class="archive-description">', '</div>' );
                        ?>
                    </header><!-- .page-header -->

					<?php if ( is_home() && ! is_front_page() ) :
						?>
						<header>
							<h2 class="page-title screen-reader-text"><?php single_post_title(); ?></h2>
						</header>
						<?php
					endif;
			?>
				<div class="blog-container">

					<?php

						/* Start the Loop */
						while ( have_posts() ) :
							the_post();

							/*
							* Include the Post-Type-specific template for the content.
							* If you want to override this in a child theme, then include a file
							* called content-___.php (where ___ is the Post Type name) and that will be used instead.
							*/
							get_template_part( 'template-parts/content', get_post_type() );

						endwhile;

					?>

				</div><!-- .blog-container -->

				<?php frannamag_posts_nav_main(); ?>

			<?php
			else :

				get_template_part( 'template-parts/content', 'none' );

			endif;
			?>

        <?php elseif ( is_single() ) : ?>

            <div class="single-post-container">

                <?php
                while ( have_posts() ) :
                    the_post();

                    get_template_part( 'template-parts/content', get_post_type() );

                    the_post_navigation(
                        array(
                            'prev_text' => '<span class="nav-subtitle">' . esc_html__( 'Previous:', 'frannamag' ) . '</span> <span class="nav-title">%title</span>',
                            'next_text' => '<span class="nav-subtitle">' . esc_html__( 'Next:', 'frannamag' ) . '</span> <span class="nav-title">%title</span>',
                        )
                    );

                    get_template_part( 'inc/templates/template-comments' );

                endwhile; // End of the loop.
                ?>

            </div><!-- .single-post-container -->

        <?php elseif ( is_search() ) : ?>

            <div class="archive-container">

                <?php if ( have_posts() ) : ?>

                    <header class="page-header">
                        <h1 class="page-title">
                            <?php
                            /* translators: %s: search query. */
                            printf( esc_html__( 'Search Results for: %s', 'frannamag' ), '<span>' . get_search_query() . '</span>' );
                            ?>
                        </h1>
                    </header><!-- .page-header -->

                    <?php
                    /* Start the Loop */
                    while ( have_posts() ) :
                        the_post();

                        /**
                         * Run the loop for the search to output the results.
                         * If you want to overload this in a child theme then include a file
                         * called content-search.php and that will be used instead.
                         */
                        get_template_part( 'template-parts/content', 'search' );

                    endwhile;

                    frannamag_posts_nav_main();

                else :

                    get_template_part( 'template-parts/content', 'none' );

                endif;
                ?>

            </div><!-- .archive-container -->

        <?php else: ?>

            <?php
				if ( have_posts() ) :

					if ( is_home() && ! is_front_page() ) :
						?>
						<header>
							<h2 class="page-title screen-reader-text"><?php single_post_title(); ?></h2>
						</header>
						<?php
					endif;
			?>
				<div class="blog-container">

					<?php

						/* Start the Loop */
						while ( have_posts() ) :
							the_post();

							/*
							* Include the Post-Type-specific template for the content.
							* If you want to override this in a child theme, then include a file
							* called content-___.php (where ___ is the Post Type name) and that will be used instead.
							*/
							get_template_part( 'template-parts/content', get_post_type() );

						endwhile;

					?>

				</div><!-- .blog-container -->

				<?php frannamag_posts_nav_main(); ?>

			<?php
			else :

				get_template_part( 'template-parts/content', 'none' );

			endif;
			?>

        <?php endif; ?>

    <?php
    }
endif;
add_action( 'frannamag_main_content_display', 'frannamag_main_content' );

/**
 * Return content after Main content
 */
if ( ! function_exists( 'frannamag_after_content' ) ) :
    function frannamag_after_content() {
        $home_layout_3    =   get_theme_mod( 'frannamag_home_layout_setting', '1' );
    ?>

        </main><!-- #main -->

        <?php get_sidebar(); ?>

    </div><!-- .content-wrapper -->
    
    <?php
    }
endif;
add_action( 'frannamag_after_content_display', 'frannamag_after_content' );

/**
 * Return Social share content
 */
if( ! function_exists( 'frannamag_social_share' ) ):

    function frannamag_social_share() {
    ?>

        <!-- AddThis BEGIN -->
        <div class="social-share-container">
            <h5 class="share-btn-title"><?php esc_html_e( 'Share this:', 'frannamag' ); ?></h5>
            <div class="addthis_inline_share_toolbox"></div>
        </div>
        <hr>
        <!-- AddThis END -->

    <?php
    }

endif;
add_action( 'frannamag_social_share_content', 'frannamag_social_share' );