<?php 
/**
 * Admin Notices
 */
get_template_part( 'inc/notices/Notice' );
get_template_part( 'inc/notices/Notices' );
get_template_part( 'inc/notices/Dismiss' );

use WPTRT\AdminNotices\Notices;

$frannamag_theme_notices = new Notices();

// Add a notice.
$frannamag_theme_notices->add( 
	'frannamag_theme_notice',           // Unique ID.
    false,                              // The title for this notice. (Set to false if no title needed)
    '<strong>'.sprintf( 
        /* Translators: 1.Theme name; 2.Link  */
        esc_html__( '%1$s activated. Please read the %2$s for tips and setup. Follow the %3$s for more themes, plugins and HTML templates', 'frannamag' ), esc_html( ucfirst( 'frannamag' ) ), '<a target="_blank" href="'.esc_url( 'https://webthemevault.xyz/frannamag' ).'" >'.esc_html__( 'theme\'s documentation', 'frannamag' ).'</a>', '<a target="_blank" href="'.esc_url( 'https://webthemevault.xyz/' ).'" >'.esc_html__( 'link', 'frannamag' ).'</a>' ).'</strong>', // The content for this notice.
    [
        'scope'         => 'user',       // Dismiss is per-user instead of global.
        'screens'       => [ 'themes' ], // Only show notice in the "themes" screen.
        'type'          => 'success',    // Make this a success (green color).
        'alt_style'     => false,        // Use alt styles.
        'option_prefix' => 'frannamag', // Change the user-meta prefix.
    ]
 );

// Boot things up.
$frannamag_theme_notices->boot();