<?php
/**
 * Return a custom excerpt
 */
function frannamag_add_custom_excerpt( $length ) {
    if( is_admin() ) {
        return $length;
    } elseif ( is_front_page() ) {
        return 30;
    } else {
        return 35;
    }

}
add_filter( 'excerpt_length', 'frannamag_add_custom_excerpt' );

/**
 * Return custom class for the Logo
 */

function frannamag_custom_logo_class( $html ) {
    $html   =   str_replace( 'custom-logo-link', 'navbar-brand', $html );
    $html   =   str_replace( 'custom-logo', 'img-fluid', $html );
    return $html;
}
add_filter( 'get_custom_logo', 'frannamag_custom_logo_class' );


/**
 * Read More Link control
 */
function frannamag_excerpt_more_btn( $more ) {
    if( is_admin() ) {
        return $more;
    }
    return "";
}
add_filter( 'excerpt_more', 'frannamag_excerpt_more_btn' );