<?php
/**
 * Enqueue scripts and styles.
 */
function frannamag_scripts()
{
    wp_enqueue_style('frannamag-style', get_stylesheet_uri(), [], FMag_VERSION);
    wp_style_add_data('frannamag-style', 'rtl', 'replace');

    wp_enqueue_style('frannamag-google-fonts', '//fonts.googleapis.com/css2?family=Playfair+Display:wght@400;600;700&display=swap', 'all');
    wp_enqueue_style('fontawesome', get_template_directory_uri() . '/assets/plugins/fontawesome/fontawesome.css', [], '5.9.0', 'all');
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/plugins/bootstrap/css/bootstrap.min.css', [], '5.3.7', 'all');
    wp_enqueue_style('bs-icons', get_template_directory_uri() . '/assets/plugins/bs-icons/font/bootstrap-icons.css', [], '1.4.0', 'all');
    wp_enqueue_style('frannamag-sm-menu-core', get_template_directory_uri() . '/assets/plugins/sm-menu/css/sm-core-css.css', [], '1.1.0', 'all');
    wp_enqueue_style('frannamag-sm-menu', get_template_directory_uri() . '/assets/plugins/sm-menu/css/sm-simple.css', [], '1.1.0', 'all');
    wp_enqueue_style('frannamag-main', get_template_directory_uri() . '/assets/css/compressed/main.min.css', [], FMag_VERSION, 'all');


    wp_enqueue_script('jquery');
    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/plugins/bootstrap/js/bootstrap.bundle.min.js', [], '5.3.7', true);
    wp_enqueue_script('frannamag-sm-menu-js', get_template_directory_uri() . '/assets/plugins/sm-menu/js/jquery.smartmenus.min.js', [], '1.1.0', true);
    wp_enqueue_script('frannamag-social-addthis', '//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-605fc83bf7e81078', [], FMag_VERSION, false);
    wp_enqueue_script('frannamag-sm-menu-init', get_template_directory_uri() . '/assets/js/menu.js', [], '1.1.0', true);
    wp_enqueue_script('frannamag-main', get_template_directory_uri() . '/assets/js/main.js', [], FMag_VERSION, true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'frannamag_scripts');
