<?php 
/**
 * Display Theme custom options
 */
function frannamag_theme_options_display( $wp_customize ) {

    $wp_customize->add_section( 'frannamag_theme_option_display_section', array(
        'title'                 =>  esc_html__( 'Theme Option Display', 'frannamag' ),
        'priority'              =>  10,
        'panel'                 =>  'frannamag_theme_options_panel'
    ) );

    // Top menu Display
    $wp_customize->add_setting( 'frannamag_top_menu_display_setting', array(
        'default'               =>  true,
        'sanitize_callback'     =>  'frannamag_sanitize_checkbox'
    ) );

    $wp_customize->add_control( new frannamag_Checkbox_Custom_control(
        $wp_customize,
        'frannamag_top_menu_display_control',
        array(
            'label'             =>  esc_html__( 'Display / Hide Top Menu', 'frannamag' ),
            'section'           =>  'frannamag_theme_option_display_section',
            'settings'          =>  'frannamag_top_menu_display_setting',
            'type'              =>  'checkbox'
        )
    ) );

    //Top Menu Date
    $wp_customize->add_setting( 'frannamag_top_menu_date_display_setting', array(
        'default'               =>  true,
        'sanitize_callback'     =>  'frannamag_sanitize_checkbox'
    ) );

    $wp_customize->add_control( new frannamag_Checkbox_Custom_control(
        $wp_customize,
        'frannamag_top_menu_date_display_control',
        array(
            'label'             =>  esc_html__( 'Display / Hide Top Menu date', 'frannamag' ),
            'section'           =>  'frannamag_theme_option_display_section',
            'settings'          =>  'frannamag_top_menu_date_display_setting',
            'type'              =>  'checkbox'
        )
    ) );

    //Main Menu Cart
    $wp_customize->add_setting( 'frannamag_menu_cart_display_setting', array(
        'default'               =>  false,
        'sanitize_callback'     =>  'frannamag_sanitize_checkbox'
    ) );

    $wp_customize->add_control( new frannamag_Checkbox_Custom_control(
        $wp_customize,
        'frannamag_menu_cart_display_control',
        array(
            'label'             =>  esc_html__( 'Display / Hide Menu Cart', 'frannamag' ),
            'description'       =>  esc_html__( 'WooCommerce need to be installed', 'frannamag' ),
            'section'           =>  'frannamag_theme_option_display_section',
            'settings'          =>  'frannamag_menu_cart_display_setting',
            'type'              =>  'checkbox'
        )
    ) );

}