<?php 

function frannamag_social_share_options( $wp_customize ) {

    $wp_customize->add_section( 'frannamag_social_share_section', array(
        'title'                 =>  esc_html__( 'Social share buttons', 'frannamag' ),
        'priority'              =>  20,
        'panel'                 =>  'frannamag_theme_options_panel'
    ) );

    //Main Menu social_icons
    $wp_customize->add_setting( 'frannamag_social_share_display_setting', array(
        'default'               =>  false,
        'sanitize_callback'     =>  'frannamag_sanitize_checkbox'
    ) );

    $wp_customize->add_control( new frannamag_Checkbox_Custom_control(
        $wp_customize,
        'frannamag_navbar_social_share_display_control',
        array(
            'label'             =>  esc_html__( 'Display / Hide social share buttons on single post', 'frannamag' ),
            'section'           =>  'frannamag_social_share_section',
            'settings'          =>  'frannamag_social_share_display_setting',
            'type'              =>  'checkbox'
        )
    ) );

    // Separator
    $wp_customize->add_setting( 'frannamag_navbar_social_separator_setting', array(
        'default'               =>  '',
        'sanitize_callback'     =>  'esc_html'
    ) );

    $wp_customize->add_control( new frannamag_Custom_Separator(
        $wp_customize,
        'frannamag_navbar_social_separator_control',
        array(
            'section'           =>  'frannamag_navbar_social_media_section',
            'settings'          =>  'frannamag_navbar_social_separator_setting',
        )
    ) );

}