<?php

function frannamag_navbar_social_media_options($wp_customize)
{
    $wp_customize->add_section('frannamag_navbar_social_media_section', array(
        'title'                 =>  esc_html__('Navbar social icons', 'frannamag'),
        'priority'              =>  15,
        'panel'                 =>  'frannamag_theme_options_panel'
    ));

    //Main Menu social_icons
    $wp_customize->add_setting('frannamag_navbar_social_icons_display_setting', array(
        'default'               =>  false,
        'sanitize_callback'     =>  'frannamag_sanitize_checkbox'
    ));

    $wp_customize->add_control(new frannamag_Checkbox_Custom_control(
        $wp_customize,
        'frannamag_navbar_social_icons_display_control',
        array(
            'label'             =>  esc_html__('Display / Hide social icons in Top Menu', 'frannamag'),
            'section'           =>  'frannamag_navbar_social_media_section',
            'settings'          =>  'frannamag_navbar_social_icons_display_setting',
            'type'              =>  'checkbox'
        )
    ));

    // Notice
    $wp_customize->add_setting('frannamag_navbar_social_notice_setting', array(
        'default'               =>  '',
        'sanitize_callback'     =>  'wp_kses_post',
    
    ));
    $wp_customize->add_control(new frannamag_Custom_Notice_Control($wp_customize, 'frannamag_navbar_social_notice_control', array(
        'description' 	        =>  esc_html__('Add profile, starting with http:// or https://', 'frannamag'),
        'settings'		        =>  'frannamag_navbar_social_notice_setting',
        'section'  		        =>  'frannamag_navbar_social_media_section',
    )));

    // Facebook Option
    $wp_customize->add_setting('frannamag_facebook_setting', array(
        'default'           =>  '',
        'sanitize_callback' =>  'esc_url_raw'
      ));
      
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        'frannamag_facebook_control',
        array(
              'label'             =>    esc_html__('Facebook', 'frannamag'),
              'section'           =>    'frannamag_navbar_social_media_section',
              'settings'          =>    'frannamag_facebook_setting',
              'type'              =>    'url'
          )
    ));

    // Instagram
    $wp_customize->add_setting('frannamag_instagram_setting', array(
        'default'           =>  '',
        'sanitize_callback' =>  'esc_url_raw'
      ));
      
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        'frannamag_instagram_control',
        array(
              'label'             =>    esc_html__('Instagram', 'frannamag'),
              'section'           =>    'frannamag_navbar_social_media_section',
              'settings'          =>    'frannamag_instagram_setting',
              'type'              =>    'url'
          )
    ));

    // Twitter
    $wp_customize->add_setting('frannamag_twitter_setting', array(
        'default'           =>  '',
        'sanitize_callback' =>  'esc_url_raw'
      ));
      
    $wp_customize->add_control(new WP_Customize_Control(
        $wp_customize,
        'frannamag_twitter_control',
        array(
              'label'             =>    esc_html__('Twitter', 'frannamag'),
              'section'           =>    'frannamag_navbar_social_media_section',
              'settings'          =>    'frannamag_twitter_setting',
              'type'              =>    'url'
          )
    ));
}
