<?php 

function frannamag_footer_widgets_display_options( $wp_customize ) {

    $wp_customize->add_section( 'frannamag_footer_widgets_display_section', array(
        'title'                 =>  esc_html__( 'Footer widgets', 'frannamag' ),
        'priority'              =>  30,
        'panel'                 =>  'frannamag_theme_options_panel'
    ) );

    $wp_customize->add_setting( 'frannamag_footer_widgets_display_setting', array(
        'default'               =>  false,
        'sanitize_callback'     =>  'frannamag_sanitize_checkbox'
    ) );

    $wp_customize->add_control( new frannamag_Checkbox_Custom_control(
        $wp_customize,
        'frannamag_footer_widgets_display_control',
        array(
            'label'             =>  esc_html__( 'Display / Hide footer widgets', 'frannamag' ),
            'section'           =>  'frannamag_footer_widgets_display_section',
            'settings'          =>  'frannamag_footer_widgets_display_setting',
            'type'              =>  'checkbox'
        )
    ) );

}