<?php 
/**
 * Sanitize Checkbox
 */
function frannamag_sanitize_checkbox( $checked ) {
    // Boolean check.
    return ( ( isset( $checked ) && true == $checked ) ? true : false );
}

/**
 * file input sanitization function
 */
function frannamag_sanitize_file_input( $file, $setting ) {
          
	//allowed file types
	$mimes = array(
		'jpg|jpeg|jpe' => 'image/jpeg',
		'gif'          => 'image/gif',
		'png'          => 'image/png'
	);
	  
	//check file type from file name
	$file_ext = wp_check_filetype( $file, $mimes );
	  
	//if file has a valid mime type return it, otherwise return default
	return ( $file_ext['ext'] ? $file : $setting->default );
}

/**
 * Sanitize Select
 */
function frannamag_sanitize_select( $input, $setting ){
          
	//input must be a slug: lowercase alphanumeric characters, dashes and underscores are allowed only
	$input = sanitize_key($input);

	//get the list of possible select options 
	$choices = $setting->manager->get_control( $setting->id )->choices;
					  
	//return input if valid or return default option
	return ( array_key_exists( $input, $choices ) ? $input : $setting->default );                
	  
}

/**
 * Radio Select Sanitize
 */
function frannamag_sanitize_layout_radio( $input ) {
	$valid_keys = array(
		'default'		=>	esc_html__( 'Default Layout', 'frannamag' ),
		'banner'		=>	esc_html__( 'Banner Layout', 'frannamag' ),
		'grid-2-col'    =>  esc_html__( 'Grid two Columns', 'frannamag' ),
		'grid-3-col'    =>  esc_html__( 'Grid three Columns', 'frannamag' ),
		'list'          =>  esc_html__( 'List', 'frannamag' ),
	);

	if ( array_key_exists( $input, $valid_keys ) ) {
		return $input;
	} else {
		return '';
	}
}

/**
 * Dropdown Pages
 */
function frannamag_sanitize_dropdown_pages( $page_id, $setting ) {
	// Ensure $input is an absolute integer.
	$page_id = absint( $page_id );
  
	// If $page_id is an ID of a published page, return it; otherwise, return the default.
	return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}

/**
 * Sanitize Custom TextArea
 */
function frannamag_sanitize_textarea( $input ) {
	$allowed		=	array(
		'a'			=>	array(
			'href'	=>	array(),
			'title'	=>	array(),
			'class'	=>	array(),
		),
		'p'			=>	array(),
		'br'		=>	array(),
	);
	return wp_kses( $input, $allowed );
}

/**
 * Sanitize Number input
 */
function frannamag_sanitize_number( $number ) {
	// Ensure $number is an absolute integer (whole number, zero or greater).
	$number = absint( $number );
	
	return $number;
}
