<?php 

function frannamag_home_layout_options( $wp_customize ) {

    $wp_customize->add_section( 'frannamag_home_layout_section', array(
        'title'                 =>  esc_html__( 'Frontpage Layout', 'frannamag' ),
        'priority'              =>  15,
        'panel'                 =>  'frannamag_layout_panel'
    ) );

    //Main Menu social_icons
    $wp_customize->add_setting( 'frannamag_home_layout_setting', array(
        'default'               =>  '1',
        'sanitize_callback'     =>  'wp_kses_post'
    ) );

    $wp_customize->add_control( new frannamag_Image_Select_Home_control(
        $wp_customize,
        'frannamag_home_layout_setting',
        array(
            'label'             =>  esc_attr__( 'Select Frontpage Layout', 'frannamag' ),
            'section'           =>  'frannamag_home_layout_section',
            'settings'          =>  'frannamag_home_layout_setting',
        )
    ) );

}